/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.service;

import org.jboss.errai.common.client.api.Caller;
import org.kie.workbench.common.stunner.core.client.api.ShapeManager;
import org.kie.workbench.common.stunner.core.client.service.ClientRuntimeError;
import org.kie.workbench.common.stunner.core.client.service.ServiceCallback;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.diagram.Metadata;
import org.kie.workbench.common.stunner.core.graph.Graph;
import org.kie.workbench.common.stunner.core.lookup.LookupManager;
import org.kie.workbench.common.stunner.core.lookup.diagram.DiagramLookupRequest;
import org.kie.workbench.common.stunner.core.lookup.diagram.DiagramRepresentation;
import org.kie.workbench.common.stunner.core.service.BaseDiagramService;
import org.kie.workbench.common.stunner.core.service.DiagramLookupService;
import org.uberfire.backend.vfs.Path;

public abstract class AbstractClientDiagramService<M extends Metadata, D extends Diagram<Graph, M>, S extends BaseDiagramService<M, D>> {
    private ShapeManager shapeManager;
    protected Caller<S> diagramServiceCaller;
    protected Caller<DiagramLookupService> diagramLookupServiceCaller;

    public AbstractClientDiagramService(ShapeManager shapeManager, Caller<S> diagramServiceCaller, Caller<DiagramLookupService> diagramLookupServiceCaller) {
        this.shapeManager = shapeManager;
        this.diagramServiceCaller = diagramServiceCaller;
        this.diagramLookupServiceCaller = diagramLookupServiceCaller;
    }

    public void create(Path path, String name, String defSetId, ServiceCallback<Path> callback) {
        ((BaseDiagramService)this.diagramServiceCaller.call(p -> callback.onSuccess((Object)path), (message, throwable) -> {
            callback.onError(new ClientRuntimeError(throwable));
            return false;
        })).create(path, name, defSetId);
    }

    public void saveOrUpdate(D diagram, ServiceCallback<D> callback) {
        ((BaseDiagramService)this.diagramServiceCaller.call(serverMetadata -> {
            this.updateClientMetadata(diagram);
            diagram.getMetadata().setPath(((Metadata)serverMetadata).getPath());
            callback.onSuccess((Object)diagram);
        }, (message, throwable) -> {
            callback.onError(new ClientRuntimeError(throwable));
            return false;
        })).saveOrUpdate(diagram);
    }

    public void add(D diagram, ServiceCallback<D> callback) {
        ((BaseDiagramService)this.diagramServiceCaller.call(v -> {
            this.updateClientMetadata(diagram);
            callback.onSuccess((Object)diagram);
        }, (message, throwable) -> {
            callback.onError(new ClientRuntimeError(throwable));
            return false;
        })).saveOrUpdate(diagram);
    }

    public void getByPath(Path path, ServiceCallback<D> callback) {
        ((BaseDiagramService)this.diagramServiceCaller.call(diagram -> {
            this.updateClientMetadata((Diagram)diagram);
            callback.onSuccess((Object)((Diagram)diagram));
        }, (message, throwable) -> {
            callback.onError(new ClientRuntimeError(throwable));
            return false;
        })).getDiagramByPath(path);
    }

    public void lookup(DiagramLookupRequest request, ServiceCallback<LookupManager.LookupResponse<DiagramRepresentation>> callback) {
        ((DiagramLookupService)this.diagramLookupServiceCaller.call(response -> callback.onSuccess((Object)((LookupManager.LookupResponse)response)), (message, throwable) -> {
            callback.onError(new ClientRuntimeError(throwable));
            return false;
        })).lookup((LookupManager.LookupRequest)request);
    }

    protected void updateClientMetadata(D diagram) {
        Metadata metadata;
        if (null != diagram && null != (metadata = diagram.getMetadata()) && AbstractClientDiagramService.isEmpty(metadata.getShapeSetId())) {
            String sId = this.shapeManager.getDefaultShapeSet(metadata.getDefinitionSetId()).getId();
            metadata.setShapeSetId(sId);
        }
    }

    private static boolean isEmpty(String s) {
        return s == null || s.trim().length() == 0;
    }
}

