/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.session.command.impl;

import com.google.gwt.logging.client.LogConfiguration;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.kie.workbench.common.stunner.core.client.api.SessionManager;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.command.CanvasCommandFactory;
import org.kie.workbench.common.stunner.core.client.canvas.controls.select.SelectionControl;
import org.kie.workbench.common.stunner.core.client.canvas.event.keyboard.KeyDownEvent;
import org.kie.workbench.common.stunner.core.client.canvas.event.keyboard.KeyboardEvent;
import org.kie.workbench.common.stunner.core.client.command.SessionCommandManager;
import org.kie.workbench.common.stunner.core.client.service.ClientRuntimeError;
import org.kie.workbench.common.stunner.core.client.session.ClientFullSession;
import org.kie.workbench.common.stunner.core.client.session.Session;
import org.kie.workbench.common.stunner.core.client.session.command.AbstractClientSessionCommand;
import org.kie.workbench.common.stunner.core.client.session.command.ClientSessionCommand;
import org.kie.workbench.common.stunner.core.command.Command;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.uberfire.commons.validation.PortablePreconditions;

@Dependent
public class DeleteSelectionSessionCommand
extends AbstractClientSessionCommand<ClientFullSession> {
    private static Logger LOGGER = Logger.getLogger(DeleteSelectionSessionCommand.class.getName());
    private final SessionManager clientSessionManager;
    private final SessionCommandManager<AbstractCanvasHandler> sessionCommandManager;
    private final CanvasCommandFactory canvasCommandFactory;

    protected DeleteSelectionSessionCommand() {
        this(null, null, null);
    }

    @Inject
    public DeleteSelectionSessionCommand(SessionManager clientSessionManager, @Session SessionCommandManager<AbstractCanvasHandler> sessionCommandManager, CanvasCommandFactory canvasCommandFactory) {
        super(false);
        this.clientSessionManager = clientSessionManager;
        this.sessionCommandManager = sessionCommandManager;
        this.canvasCommandFactory = canvasCommandFactory;
    }

    @Override
    public <T> void execute(ClientSessionCommand.Callback<T> callback) {
        PortablePreconditions.checkNotNull((String)"callback", callback);
        if (null != ((ClientFullSession)this.getSession()).getSelectionControl()) {
            AbstractCanvasHandler canvasHandler = (AbstractCanvasHandler)((ClientFullSession)this.getSession()).getCanvasHandler();
            SelectionControl selectionControl = ((ClientFullSession)this.getSession()).getSelectionControl();
            Collection selectedItems = selectionControl.getSelectedItems();
            if (selectedItems != null && !selectedItems.isEmpty()) {
                selectedItems.stream().forEach(selectedItemUUID -> {
                    Node element = canvasHandler.getGraphIndex().getNode(selectedItemUUID);
                    if (element == null) {
                        element = canvasHandler.getGraphIndex().getEdge(selectedItemUUID);
                        if (element != null) {
                            this.log(Level.FINE, "Deleting edge with id " + element.getUUID());
                            this.sessionCommandManager.execute((Object)canvasHandler, (Command)this.canvasCommandFactory.deleteConnector((Edge)element));
                        }
                    } else {
                        this.log(Level.FINE, "Deleting node with id " + element.getUUID());
                        this.sessionCommandManager.execute((Object)canvasHandler, (Command)this.canvasCommandFactory.deleteNode(element));
                    }
                });
            } else {
                this.log(Level.FINE, "Cannot delete element, no element selected on canvas.");
            }
            callback.onSuccess(null);
        }
    }

    void onKeyDownEvent(@Observes KeyDownEvent keyDownEvent) {
        boolean isSameSession;
        PortablePreconditions.checkNotNull((String)"keyDownEvent", (Object)keyDownEvent);
        KeyboardEvent.Key key = keyDownEvent.getKey();
        boolean isDeleteKey = null != key && KeyboardEvent.Key.DELETE.equals((Object)key);
        boolean bl = isSameSession = null != this.getSession() && ((ClientFullSession)this.getSession()).equals(this.clientSessionManager.getCurrentSession());
        if (isDeleteKey && isSameSession) {
            this.execute(new ClientSessionCommand.Callback<Object>(){

                @Override
                public void onSuccess(Object result) {
                }

                @Override
                public void onError(ClientRuntimeError error) {
                    LOGGER.log(Level.SEVERE, "Error while trying to delete selected items. Message=[" + error.toString() + "]", error.getThrowable());
                }
            });
        }
    }

    private void log(Level level, String message) {
        if (LogConfiguration.loggingIsEnabled()) {
            LOGGER.log(level, message);
        }
    }
}

