/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.session.command.impl;

import javax.enterprise.context.Dependent;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.event.command.CanvasCommandExecutedEvent;
import org.kie.workbench.common.stunner.core.client.canvas.event.command.CanvasUndoCommandExecutedEvent;
import org.kie.workbench.common.stunner.core.client.command.SessionCommandManager;
import org.kie.workbench.common.stunner.core.client.session.ClientFullSession;
import org.kie.workbench.common.stunner.core.client.session.Session;
import org.kie.workbench.common.stunner.core.client.session.command.AbstractClientSessionCommand;
import org.kie.workbench.common.stunner.core.client.session.command.ClientSessionCommand;
import org.kie.workbench.common.stunner.core.command.CommandResult;
import org.uberfire.commons.validation.PortablePreconditions;

@Dependent
public class UndoSessionCommand
extends AbstractClientSessionCommand<ClientFullSession> {
    private final SessionCommandManager<AbstractCanvasHandler> sessionCommandManager;

    protected UndoSessionCommand() {
        this(null);
    }

    @Inject
    public UndoSessionCommand(@Session SessionCommandManager<AbstractCanvasHandler> sessionCommandManager) {
        super(false);
        this.sessionCommandManager = sessionCommandManager;
    }

    @Override
    public <T> void execute(ClientSessionCommand.Callback<T> callback) {
        PortablePreconditions.checkNotNull((String)"callback", callback);
        SessionCommandManager<AbstractCanvasHandler> scm = this.getSessionCommandManager();
        if (null != scm) {
            CommandResult result = this.getSessionCommandManager().undo((Object)((AbstractCanvasHandler)((ClientFullSession)this.getSession()).getCanvasHandler()));
            this.checkState();
            callback.onSuccess(result);
        }
    }

    void onCommandExecuted(@Observes CanvasCommandExecutedEvent commandExecutedEvent) {
        PortablePreconditions.checkNotNull((String)"commandExecutedEvent", (Object)commandExecutedEvent);
        this.checkState();
    }

    void onCommandUndoExecuted(@Observes CanvasUndoCommandExecutedEvent commandUndoExecutedEvent) {
        PortablePreconditions.checkNotNull((String)"commandUndoExecutedEvent", (Object)commandUndoExecutedEvent);
        this.checkState();
    }

    private void checkState() {
        if (null != this.getSession()) {
            SessionCommandManager<AbstractCanvasHandler> cm = this.getSessionCommandManager();
            boolean isHistoryEmpty = cm == null || cm.getRegistry().getCommandHistory().isEmpty();
            this.setEnabled(!isHistoryEmpty);
        } else {
            this.setEnabled(false);
        }
        this.fire();
    }

    private SessionCommandManager<AbstractCanvasHandler> getSessionCommandManager() {
        return this.sessionCommandManager;
    }
}

