/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.shape.view.glyph;

import java.util.LinkedList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.kie.workbench.common.stunner.core.client.shape.view.glyph.GlyphBuilder;
import org.kie.workbench.common.stunner.core.client.shape.view.glyph.GlyphBuilderFactory;
import org.kie.workbench.common.stunner.core.definition.shape.GlyphDef;

@ApplicationScoped
public class GlyphBuilderFactoryImpl
implements GlyphBuilderFactory {
    private final ManagedInstance<GlyphBuilder> glyphBuilderInstances;
    private final List<GlyphBuilder> builders = new LinkedList<GlyphBuilder>();

    protected GlyphBuilderFactoryImpl() {
        this(null);
    }

    @Inject
    public GlyphBuilderFactoryImpl(ManagedInstance<GlyphBuilder> glyphBuilderInstances) {
        this.glyphBuilderInstances = glyphBuilderInstances;
    }

    @PostConstruct
    public void init() {
        this.glyphBuilderInstances.forEach(this.builders::add);
    }

    public <D extends GlyphDef<?>> GlyphBuilder<?, D> getBuilder(D glyphDefinition) {
        GlyphBuilder<?, D> result = this._getBuilder(glyphDefinition);
        if (null == result) {
            throw new UnsupportedOperationException("No glyph builder instance for glyph definition type [" + glyphDefinition.getClass() + "]");
        }
        return result;
    }

    private <D extends GlyphDef<?>> GlyphBuilder<?, D> _getBuilder(D glyphDefinition) {
        return this.builders.stream().filter(builder -> builder.getType().equals(glyphDefinition.getType())).findFirst().orElse(null);
    }
}

