/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.util;

import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.kie.workbench.common.stunner.core.client.canvas.Canvas;
import org.kie.workbench.common.stunner.core.client.canvas.CanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.Layer;
import org.kie.workbench.common.stunner.core.client.canvas.controls.select.SelectionControl;
import org.kie.workbench.common.stunner.core.client.session.ClientReadOnlySession;
import org.kie.workbench.common.stunner.core.client.session.ClientSession;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.graph.Graph;
import org.kie.workbench.common.stunner.core.graph.processing.index.bounds.GraphBoundsIndexer;

@Dependent
public class ClientSessionUtils {
    private GraphBoundsIndexer graphBoundsIndexer;

    protected ClientSessionUtils() {
        this(null);
    }

    @Inject
    public ClientSessionUtils(GraphBoundsIndexer graphBoundsIndexer) {
        this.graphBoundsIndexer = graphBoundsIndexer;
    }

    public String canvasToImageData(ClientSession session) {
        SelectionControl selectionControl;
        if (session instanceof ClientReadOnlySession && null != (selectionControl = ((ClientReadOnlySession)session).getSelectionControl())) {
            selectionControl.clearSelection();
        }
        CanvasHandler canvasHandler = session.getCanvasHandler();
        return this.canvasToImageData(canvasHandler);
    }

    private String canvasToImageData(CanvasHandler<?, Canvas<?>> canvasHandler) {
        Layer layer;
        Diagram diagram = canvasHandler.getDiagram();
        Graph graph = diagram.getGraph();
        double[] dBounds = this.graphBoundsIndexer.build((Object)graph).getTrimmedBounds();
        String thumbData = null;
        if (dBounds[2] > 0.0 && dBounds[3] > 0.0 && null != (layer = canvasHandler.getCanvas().getLayer())) {
            thumbData = layer.toDataURL((int)dBounds[0], (int)dBounds[1], (int)dBounds[2], (int)dBounds[3]);
        }
        return thumbData;
    }
}

