/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.util;

import com.google.gwt.core.client.GWT;
import org.kie.workbench.common.stunner.core.client.canvas.Canvas;
import org.kie.workbench.common.stunner.core.client.canvas.CanvasHandler;
import org.kie.workbench.common.stunner.core.client.shape.EdgeShape;
import org.kie.workbench.common.stunner.core.client.shape.MutationContext;
import org.kie.workbench.common.stunner.core.client.shape.Shape;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Node;

public class ShapeUtils {
    public static String getModuleAbsolutePath(String path) {
        return GWT.getModuleBaseURL() + path;
    }

    public static void applyConnections(Edge<?, ?> edge, CanvasHandler canvasHandler, MutationContext mutationContext) {
        Canvas canvas = canvasHandler.getCanvas();
        Node sourceNode = edge.getSourceNode();
        Node targetNode = edge.getTargetNode();
        Shape source = sourceNode != null ? canvas.getShape(sourceNode.getUUID()) : null;
        Shape target = targetNode != null ? canvas.getShape(targetNode.getUUID()) : null;
        EdgeShape connector = (EdgeShape)canvas.getShape(edge.getUUID());
        connector.applyConnections(edge, source != null ? source.getShapeView() : null, target != null ? target.getShapeView() : null, mutationContext);
    }

    public static boolean isStaticMutation(MutationContext mutationContext) {
        return mutationContext == null || MutationContext.Type.STATIC.equals((Object)mutationContext.getType());
    }

    public static boolean isAnimationMutation(Object view, MutationContext mutationContext) {
        return mutationContext != null && MutationContext.Type.ANIMATION.equals((Object)mutationContext.getType());
    }

    public static double[] getContainerXY(Shape shape) {
        return new double[]{shape.getShapeView().getShapeX(), shape.getShapeView().getShapeY()};
    }

    public static double dist(double x0, double y0, double x1, double y1) {
        double dx = Math.abs(x1 - x0);
        double dy = Math.abs(y1 - y0);
        return Math.sqrt(dx * dx + dy * dy);
    }
}

