/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.util;

import com.google.gwt.core.client.GWT;
import com.google.gwt.logging.client.LogConfiguration;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.controls.builder.ElementBuilderControl;
import org.kie.workbench.common.stunner.core.client.command.CanvasCommandManager;
import org.kie.workbench.common.stunner.core.client.command.CanvasViolation;
import org.kie.workbench.common.stunner.core.client.service.ClientRuntimeError;
import org.kie.workbench.common.stunner.core.client.session.ClientFullSession;
import org.kie.workbench.common.stunner.core.client.session.impl.AbstractClientSession;
import org.kie.workbench.common.stunner.core.command.Command;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.diagram.Metadata;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.content.Bounds;
import org.kie.workbench.common.stunner.core.graph.content.view.View;

public class StunnerClientLogger {
    private static Logger LOGGER = Logger.getLogger(StunnerClientLogger.class.getName());
    private static final Level[] LOG_LEVELS = new Level[]{Level.FINE, Level.INFO, Level.WARNING, Level.SEVERE};

    public static String getErrorMessage(ClientRuntimeError error) {
        Throwable t2;
        String message = error.getMessage();
        Throwable t1 = error.getThrowable();
        Throwable throwable = t2 = t1 != null ? t1.getCause() : null;
        if (null != t2) {
            return t2.getMessage();
        }
        if (null != t1) {
            return t1.getMessage();
        }
        return null != message ? message : " -- No message -- ";
    }

    public static void logBounds(Element<View<?>> item) {
        Bounds bounds = ((View)item.getContent()).getBounds();
        Bounds.Bound ul = bounds.getUpperLeft();
        Bounds.Bound lr = bounds.getLowerRight();
        LOGGER.log(Level.FINE, "Bounds for [" + item.getUUID() + "] ARE { UL=[" + ul.getX() + ", " + ul.getY() + "] LR=[ " + lr.getX() + ", " + lr.getY() + "] }");
    }

    public static void logSessionInfo(AbstractClientSession session) {
        StunnerClientLogger.log("************ Session Info ****************");
        if (null != session) {
            StunnerClientLogger.log("Session = " + session.toString());
            StunnerClientLogger.log("Canvas = " + session.getCanvas().toString());
            if (null != session.getCanvasHandler()) {
                AbstractCanvasHandler canvasHandler = session.getCanvasHandler();
                StunnerClientLogger.log("CanvasHandler = " + ((Object)canvasHandler).toString());
                Diagram diagram = canvasHandler.getDiagram();
                if (null != diagram) {
                    StunnerClientLogger.log("Diagram name = " + diagram.getName());
                    StunnerClientLogger.log("Graph uuid = " + (null != diagram.getGraph() ? diagram.getGraph().getUUID() : "null"));
                    Metadata metadata = diagram.getMetadata();
                    if (null != metadata) {
                        StunnerClientLogger.log("Metadata defSetId = " + metadata.getDefinitionSetId());
                        StunnerClientLogger.log("Metadata shapeSetId = " + metadata.getShapeSetId());
                        StunnerClientLogger.log("Metadata canvas root = " + metadata.getCanvasRootUUID());
                        StunnerClientLogger.log("Metadata title = " + metadata.getTitle());
                    } else {
                        StunnerClientLogger.log("Metadata = null");
                    }
                } else {
                    StunnerClientLogger.log("Diagram = null");
                }
            } else {
                StunnerClientLogger.log("CanvasHandler = null");
            }
            if (session instanceof ClientFullSession) {
                StunnerClientLogger.logFullSessionInfo((ClientFullSession)session);
            }
        } else {
            StunnerClientLogger.log("Session is null");
        }
        StunnerClientLogger.log("******************************************");
    }

    private static void logFullSessionInfo(ClientFullSession session) {
        ElementBuilderControl builderControl = session.getBuilderControl();
        CanvasCommandManager canvasCommandManager = session.getCommandManager();
        StunnerClientLogger.log("Builder control = " + (null != builderControl ? builderControl.toString() : "null"));
        StunnerClientLogger.log("Canvas command mgr = " + (null != canvasCommandManager ? canvasCommandManager.toString() : "null"));
    }

    public static void logCommandHistory(ClientFullSession session) {
        if (null != session) {
            List history = session.getCommandRegistry().getCommandHistory();
            StunnerClientLogger.logCommandHistory(history);
        }
    }

    private static void logCommandHistory(List<Command<AbstractCanvasHandler, CanvasViolation>> history) {
        StunnerClientLogger.log("**** COMMAND HISTORY START *********");
        if (null == history) {
            StunnerClientLogger.log("History is null");
        } else {
            int[] x = new int[]{0};
            history.stream().forEach(command -> {
                StunnerClientLogger.logCommand(x[0], (Command<AbstractCanvasHandler, CanvasViolation>)command);
                x[0] = x[0] + 1;
            });
            StunnerClientLogger.log(" ( FOUND " + x[0] + " ENTRIES )");
        }
        StunnerClientLogger.log("**** COMMAND HISTORY END *********");
    }

    private static void logCommand(int count, Command<AbstractCanvasHandler, CanvasViolation> command) {
        if (null == command) {
            StunnerClientLogger.log("Command is null");
        } else {
            StunnerClientLogger.log("Command [" + count + "] => " + command.toString());
        }
    }

    public static void switchLogLevel() {
        Level level = Logger.getLogger("org.kie.workbench.common.stunner").getLevel();
        int idx = StunnerClientLogger.getLevelIndex(level);
        Level newLevel = idx > -1 && idx + 1 < LOG_LEVELS.length ? LOG_LEVELS[idx + 1] : LOG_LEVELS[0];
        GWT.log((String)("*** Switching to log level: " + newLevel.toString()));
        Logger.getLogger("org.kie.workbench.common.stunner").setLevel(newLevel);
    }

    private static int getLevelIndex(Level level) {
        int idx = -1;
        if (null != level) {
            for (Level l : LOG_LEVELS) {
                if (level.equals(l)) {
                    return idx + 1;
                }
                ++idx;
            }
        }
        return idx;
    }

    private static void log(String message) {
        if (LogConfiguration.loggingIsEnabled()) {
            LOGGER.log(Level.INFO, message);
        }
    }

    private static void log(Level level, String message) {
        if (LogConfiguration.loggingIsEnabled()) {
            LOGGER.log(level, message);
        }
    }
}

