/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.validation.canvas;

import java.util.LinkedList;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.kie.workbench.common.stunner.core.client.canvas.Canvas;
import org.kie.workbench.common.stunner.core.client.canvas.CanvasHandler;
import org.kie.workbench.common.stunner.core.client.shape.Shape;
import org.kie.workbench.common.stunner.core.client.shape.ShapeState;
import org.kie.workbench.common.stunner.core.client.validation.canvas.CanvasValidationViolationImpl;
import org.kie.workbench.common.stunner.core.client.validation.canvas.CanvasValidator;
import org.kie.workbench.common.stunner.core.client.validation.canvas.CanvasValidatorCallback;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.Graph;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.rule.graph.GraphRulesManager;
import org.kie.workbench.common.stunner.core.validation.AbstractValidator;
import org.kie.workbench.common.stunner.core.validation.ValidationViolation;
import org.kie.workbench.common.stunner.core.validation.ValidatorCallback;
import org.kie.workbench.common.stunner.core.validation.graph.AbstractGraphValidatorCallback;
import org.kie.workbench.common.stunner.core.validation.graph.GraphValidationViolation;
import org.kie.workbench.common.stunner.core.validation.graph.GraphValidator;

@ApplicationScoped
public class CanvasValidatorImpl
extends AbstractValidator<CanvasHandler, CanvasValidatorCallback>
implements CanvasValidator {
    GraphValidator graphValidator;
    private GraphRulesManager rulesManager = null;

    protected CanvasValidatorImpl() {
        this(null);
    }

    @Inject
    public CanvasValidatorImpl(GraphValidator graphValidator) {
        this.graphValidator = graphValidator;
    }

    public CanvasValidator withRulesManager(GraphRulesManager rulesManager) {
        this.rulesManager = rulesManager;
        return this;
    }

    public void validate(final CanvasHandler canvasHandler, final CanvasValidatorCallback callback) {
        Graph graph = canvasHandler.getDiagram().getGraph();
        this.graphValidator.withRulesManager(this.rulesManager).validate((Object)graph, (ValidatorCallback)new AbstractGraphValidatorCallback(){

            public void afterValidateNode(Node node, Iterable<GraphValidationViolation> violations) {
                super.afterValidateNode(node, violations);
                CanvasValidatorImpl.this.checkViolations(canvasHandler, (Element)node, violations);
            }

            public void afterValidateEdge(Edge edge, Iterable<GraphValidationViolation> violations) {
                super.afterValidateEdge(edge, violations);
                CanvasValidatorImpl.this.checkViolations(canvasHandler, (Element)edge, violations);
            }

            public void onSuccess() {
                callback.onSuccess();
            }

            public void onFail(Iterable<GraphValidationViolation> violations) {
                LinkedList<CanvasValidationViolationImpl> canvasValidationViolations = new LinkedList<CanvasValidationViolationImpl>();
                for (GraphValidationViolation violation : violations) {
                    CanvasValidationViolationImpl canvasValidationViolation = new CanvasValidationViolationImpl(canvasHandler, (ValidationViolation<?>)violation);
                    canvasValidationViolations.add(canvasValidationViolation);
                }
                callback.onFail(canvasValidationViolations);
            }
        });
    }

    private void checkViolations(CanvasHandler canvasHandler, Element element, Iterable<GraphValidationViolation> violations) {
        if (this.hasViolations(violations)) {
            Canvas canvas = canvasHandler.getCanvas();
            Shape shape = this.getShape(canvasHandler, element.getUUID());
            shape.applyState(ShapeState.INVALID);
            canvas.draw();
        }
    }

    private Shape getShape(CanvasHandler canvasHandler, String uuid) {
        return canvasHandler.getCanvas().getShape(uuid);
    }

    private boolean hasViolations(Iterable<GraphValidationViolation> violations) {
        return violations != null && violations.iterator().hasNext();
    }
}

