/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.api;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.stunner.core.client.api.AbstractClientSessionManager;
import org.kie.workbench.common.stunner.core.client.session.ClientSession;
import org.kie.workbench.common.stunner.core.client.session.ClientSessionFactory;
import org.kie.workbench.common.stunner.core.client.session.impl.AbstractClientSession;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=GwtMockitoTestRunner.class)
public class AbstractClientSessionManagerTest {
    @Mock
    AbstractClientSession session;
    @Mock
    AbstractClientSession session1;
    private AbstractClientSessionManager tested;

    @Before
    public void setup() throws Exception {
        this.tested = (AbstractClientSessionManager)Mockito.spy((Object)new AbstractClientSessionManager(){

            protected <D extends Diagram> List<ClientSessionFactory<?>> getFactories(D diagram) {
                return new ArrayList(0);
            }

            protected void postOpen() {
            }

            protected void postPause() {
            }

            protected void postResume() {
            }

            protected void postDestroy() {
            }
        });
    }

    @Test
    public void testOpen() {
        this.tested.open((ClientSession)this.session);
        Assert.assertEquals((Object)this.session, (Object)this.tested.getCurrentSession());
        ((AbstractClientSession)Mockito.verify((Object)this.session, (VerificationMode)Mockito.times((int)1))).open();
        ((AbstractClientSession)Mockito.verify((Object)this.session, (VerificationMode)Mockito.times((int)0))).pause();
        ((AbstractClientSession)Mockito.verify((Object)this.session, (VerificationMode)Mockito.times((int)0))).resume();
        ((AbstractClientSession)Mockito.verify((Object)this.session, (VerificationMode)Mockito.times((int)0))).destroy();
        ((AbstractClientSessionManager)Mockito.verify((Object)this.tested, (VerificationMode)Mockito.times((int)1))).postOpen();
        ((AbstractClientSessionManager)Mockito.verify((Object)this.tested, (VerificationMode)Mockito.times((int)0))).postPause();
        ((AbstractClientSessionManager)Mockito.verify((Object)this.tested, (VerificationMode)Mockito.times((int)0))).postResume();
        ((AbstractClientSessionManager)Mockito.verify((Object)this.tested, (VerificationMode)Mockito.times((int)0))).postDestroy();
    }

    @Test
    public void testOpenAnotherSession() {
        this.tested.current = this.session;
        this.tested.open((ClientSession)this.session1);
        Assert.assertEquals((Object)this.session1, (Object)this.tested.getCurrentSession());
        ((AbstractClientSession)Mockito.verify((Object)this.session, (VerificationMode)Mockito.times((int)1))).pause();
        ((AbstractClientSession)Mockito.verify((Object)this.session, (VerificationMode)Mockito.times((int)0))).open();
        ((AbstractClientSession)Mockito.verify((Object)this.session, (VerificationMode)Mockito.times((int)0))).resume();
        ((AbstractClientSession)Mockito.verify((Object)this.session, (VerificationMode)Mockito.times((int)0))).destroy();
        ((AbstractClientSession)Mockito.verify((Object)this.session1, (VerificationMode)Mockito.times((int)1))).open();
        ((AbstractClientSession)Mockito.verify((Object)this.session1, (VerificationMode)Mockito.times((int)0))).pause();
        ((AbstractClientSession)Mockito.verify((Object)this.session1, (VerificationMode)Mockito.times((int)0))).resume();
        ((AbstractClientSession)Mockito.verify((Object)this.session1, (VerificationMode)Mockito.times((int)0))).destroy();
        ((AbstractClientSessionManager)Mockito.verify((Object)this.tested, (VerificationMode)Mockito.times((int)1))).postOpen();
        ((AbstractClientSessionManager)Mockito.verify((Object)this.tested, (VerificationMode)Mockito.times((int)1))).postPause();
        ((AbstractClientSessionManager)Mockito.verify((Object)this.tested, (VerificationMode)Mockito.times((int)0))).postResume();
        ((AbstractClientSessionManager)Mockito.verify((Object)this.tested, (VerificationMode)Mockito.times((int)0))).postDestroy();
    }

    @Test
    public void testPause() {
        this.tested.current = this.session;
        this.tested.pause();
        Assert.assertEquals((Object)this.session, (Object)this.tested.getCurrentSession());
        ((AbstractClientSession)Mockito.verify((Object)this.session, (VerificationMode)Mockito.times((int)0))).open();
        ((AbstractClientSession)Mockito.verify((Object)this.session, (VerificationMode)Mockito.times((int)1))).pause();
        ((AbstractClientSession)Mockito.verify((Object)this.session, (VerificationMode)Mockito.times((int)0))).resume();
        ((AbstractClientSession)Mockito.verify((Object)this.session, (VerificationMode)Mockito.times((int)0))).destroy();
        ((AbstractClientSessionManager)Mockito.verify((Object)this.tested, (VerificationMode)Mockito.times((int)0))).postOpen();
        ((AbstractClientSessionManager)Mockito.verify((Object)this.tested, (VerificationMode)Mockito.times((int)1))).postPause();
        ((AbstractClientSessionManager)Mockito.verify((Object)this.tested, (VerificationMode)Mockito.times((int)0))).postResume();
        ((AbstractClientSessionManager)Mockito.verify((Object)this.tested, (VerificationMode)Mockito.times((int)0))).postDestroy();
    }

    @Test
    public void testResume() {
        this.tested.current = this.session1;
        this.tested.resume((ClientSession)this.session);
        Assert.assertEquals((Object)this.session, (Object)this.tested.getCurrentSession());
        ((AbstractClientSession)Mockito.verify((Object)this.session1, (VerificationMode)Mockito.times((int)0))).open();
        ((AbstractClientSession)Mockito.verify((Object)this.session1, (VerificationMode)Mockito.times((int)1))).pause();
        ((AbstractClientSession)Mockito.verify((Object)this.session1, (VerificationMode)Mockito.times((int)0))).resume();
        ((AbstractClientSession)Mockito.verify((Object)this.session1, (VerificationMode)Mockito.times((int)0))).destroy();
        ((AbstractClientSession)Mockito.verify((Object)this.session, (VerificationMode)Mockito.times((int)0))).open();
        ((AbstractClientSession)Mockito.verify((Object)this.session, (VerificationMode)Mockito.times((int)0))).pause();
        ((AbstractClientSession)Mockito.verify((Object)this.session, (VerificationMode)Mockito.times((int)1))).resume();
        ((AbstractClientSession)Mockito.verify((Object)this.session, (VerificationMode)Mockito.times((int)0))).destroy();
        ((AbstractClientSessionManager)Mockito.verify((Object)this.tested, (VerificationMode)Mockito.times((int)0))).postOpen();
        ((AbstractClientSessionManager)Mockito.verify((Object)this.tested, (VerificationMode)Mockito.times((int)1))).postPause();
        ((AbstractClientSessionManager)Mockito.verify((Object)this.tested, (VerificationMode)Mockito.times((int)1))).postResume();
        ((AbstractClientSessionManager)Mockito.verify((Object)this.tested, (VerificationMode)Mockito.times((int)0))).postDestroy();
    }

    @Test
    public void testDestroy() {
        this.tested.current = this.session;
        this.tested.destroy();
        Assert.assertNull((Object)this.tested.getCurrentSession());
        ((AbstractClientSession)Mockito.verify((Object)this.session, (VerificationMode)Mockito.times((int)0))).open();
        ((AbstractClientSession)Mockito.verify((Object)this.session, (VerificationMode)Mockito.times((int)0))).pause();
        ((AbstractClientSession)Mockito.verify((Object)this.session, (VerificationMode)Mockito.times((int)0))).resume();
        ((AbstractClientSession)Mockito.verify((Object)this.session, (VerificationMode)Mockito.times((int)1))).destroy();
        ((AbstractClientSessionManager)Mockito.verify((Object)this.tested, (VerificationMode)Mockito.times((int)0))).postOpen();
        ((AbstractClientSessionManager)Mockito.verify((Object)this.tested, (VerificationMode)Mockito.times((int)0))).postPause();
        ((AbstractClientSessionManager)Mockito.verify((Object)this.tested, (VerificationMode)Mockito.times((int)0))).postResume();
        ((AbstractClientSessionManager)Mockito.verify((Object)this.tested, (VerificationMode)Mockito.times((int)1))).postDestroy();
    }
}

