/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.api;

import com.google.gwtmockito.GwtMockitoTestRunner;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.stunner.core.client.api.ClientSessionManagerImpl;
import org.kie.workbench.common.stunner.core.client.service.ClientRuntimeError;
import org.kie.workbench.common.stunner.core.client.session.ClientSession;
import org.kie.workbench.common.stunner.core.client.session.ClientSessionFactory;
import org.kie.workbench.common.stunner.core.client.session.event.OnSessionErrorEvent;
import org.kie.workbench.common.stunner.core.client.session.event.SessionDestroyedEvent;
import org.kie.workbench.common.stunner.core.client.session.event.SessionOpenedEvent;
import org.kie.workbench.common.stunner.core.client.session.event.SessionPausedEvent;
import org.kie.workbench.common.stunner.core.client.session.event.SessionResumedEvent;
import org.kie.workbench.common.stunner.core.client.session.impl.AbstractClientSession;
import org.kie.workbench.common.stunner.core.command.exception.CommandException;
import org.kie.workbench.common.stunner.core.util.DefinitionUtils;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.mocks.EventSourceMock;

@RunWith(value=GwtMockitoTestRunner.class)
public class ClientSessionManagerImplTest {
    @Mock
    DefinitionUtils definitionUtils;
    @Mock
    ManagedInstance<ClientSessionFactory> sessionFactoriesInstances;
    @Mock
    EventSourceMock<SessionOpenedEvent> sessionOpenedEventMock;
    @Mock
    EventSourceMock<SessionPausedEvent> sessionPausedEventMock;
    @Mock
    EventSourceMock<SessionResumedEvent> sessionResumedEventMock;
    @Mock
    EventSourceMock<SessionDestroyedEvent> sessionDestroyedEventMock;
    @Mock
    EventSourceMock<OnSessionErrorEvent> sessionErrorEventMock;
    @Mock
    AbstractClientSession session;
    @Mock
    AbstractClientSession session1;
    private ClientSessionManagerImpl tested;

    @Before
    public void setup() throws Exception {
        this.tested = new ClientSessionManagerImpl(this.definitionUtils, this.sessionFactoriesInstances, this.sessionOpenedEventMock, this.sessionDestroyedEventMock, this.sessionPausedEventMock, this.sessionResumedEventMock, this.sessionErrorEventMock);
    }

    @Test
    public void testPostOpen() {
        this.tested.open((ClientSession)this.session);
        ((EventSourceMock)Mockito.verify(this.sessionOpenedEventMock, (VerificationMode)Mockito.times((int)1))).fire(Matchers.any(SessionOpenedEvent.class));
        ((EventSourceMock)Mockito.verify(this.sessionPausedEventMock, (VerificationMode)Mockito.times((int)0))).fire(Matchers.any(SessionPausedEvent.class));
        ((EventSourceMock)Mockito.verify(this.sessionResumedEventMock, (VerificationMode)Mockito.times((int)0))).fire(Matchers.any(SessionResumedEvent.class));
        ((EventSourceMock)Mockito.verify(this.sessionErrorEventMock, (VerificationMode)Mockito.times((int)0))).fire(Matchers.any(OnSessionErrorEvent.class));
        ((EventSourceMock)Mockito.verify(this.sessionDestroyedEventMock, (VerificationMode)Mockito.times((int)0))).fire(Matchers.any(SessionDestroyedEvent.class));
    }

    @Test
    public void testPostOpenAnotherSession() {
        this.tested.current = this.session;
        this.tested.open((ClientSession)this.session1);
        ((EventSourceMock)Mockito.verify(this.sessionOpenedEventMock, (VerificationMode)Mockito.times((int)1))).fire(Matchers.any(SessionOpenedEvent.class));
        ((EventSourceMock)Mockito.verify(this.sessionPausedEventMock, (VerificationMode)Mockito.times((int)1))).fire(Matchers.any(SessionPausedEvent.class));
        ((EventSourceMock)Mockito.verify(this.sessionResumedEventMock, (VerificationMode)Mockito.times((int)0))).fire(Matchers.any(SessionResumedEvent.class));
        ((EventSourceMock)Mockito.verify(this.sessionErrorEventMock, (VerificationMode)Mockito.times((int)0))).fire(Matchers.any(OnSessionErrorEvent.class));
        ((EventSourceMock)Mockito.verify(this.sessionDestroyedEventMock, (VerificationMode)Mockito.times((int)0))).fire(Matchers.any(SessionDestroyedEvent.class));
    }

    @Test
    public void testPostPause() {
        this.tested.current = this.session;
        this.tested.pause();
        ((EventSourceMock)Mockito.verify(this.sessionOpenedEventMock, (VerificationMode)Mockito.times((int)0))).fire(Matchers.any(SessionOpenedEvent.class));
        ((EventSourceMock)Mockito.verify(this.sessionPausedEventMock, (VerificationMode)Mockito.times((int)1))).fire(Matchers.any(SessionPausedEvent.class));
        ((EventSourceMock)Mockito.verify(this.sessionResumedEventMock, (VerificationMode)Mockito.times((int)0))).fire(Matchers.any(SessionResumedEvent.class));
        ((EventSourceMock)Mockito.verify(this.sessionErrorEventMock, (VerificationMode)Mockito.times((int)0))).fire(Matchers.any(OnSessionErrorEvent.class));
        ((EventSourceMock)Mockito.verify(this.sessionDestroyedEventMock, (VerificationMode)Mockito.times((int)0))).fire(Matchers.any(SessionDestroyedEvent.class));
    }

    @Test
    public void testPostResume() {
        this.tested.current = this.session1;
        this.tested.resume((ClientSession)this.session);
        ((EventSourceMock)Mockito.verify(this.sessionOpenedEventMock, (VerificationMode)Mockito.times((int)0))).fire(Matchers.any(SessionOpenedEvent.class));
        ((EventSourceMock)Mockito.verify(this.sessionPausedEventMock, (VerificationMode)Mockito.times((int)1))).fire(Matchers.any(SessionPausedEvent.class));
        ((EventSourceMock)Mockito.verify(this.sessionResumedEventMock, (VerificationMode)Mockito.times((int)1))).fire(Matchers.any(SessionResumedEvent.class));
        ((EventSourceMock)Mockito.verify(this.sessionErrorEventMock, (VerificationMode)Mockito.times((int)0))).fire(Matchers.any(OnSessionErrorEvent.class));
        ((EventSourceMock)Mockito.verify(this.sessionDestroyedEventMock, (VerificationMode)Mockito.times((int)0))).fire(Matchers.any(SessionDestroyedEvent.class));
    }

    @Test
    public void testPostDestroy() {
        this.tested.current = this.session;
        this.tested.destroy();
        ((EventSourceMock)Mockito.verify(this.sessionOpenedEventMock, (VerificationMode)Mockito.times((int)0))).fire(Matchers.any(SessionOpenedEvent.class));
        ((EventSourceMock)Mockito.verify(this.sessionPausedEventMock, (VerificationMode)Mockito.times((int)0))).fire(Matchers.any(SessionPausedEvent.class));
        ((EventSourceMock)Mockito.verify(this.sessionResumedEventMock, (VerificationMode)Mockito.times((int)0))).fire(Matchers.any(SessionResumedEvent.class));
        ((EventSourceMock)Mockito.verify(this.sessionErrorEventMock, (VerificationMode)Mockito.times((int)0))).fire(Matchers.any(OnSessionErrorEvent.class));
        ((EventSourceMock)Mockito.verify(this.sessionDestroyedEventMock, (VerificationMode)Mockito.times((int)1))).fire(Matchers.any(SessionDestroyedEvent.class));
    }

    @Test
    public void testHandleClientError() {
        this.tested.current = this.session;
        ClientRuntimeError error = (ClientRuntimeError)Mockito.mock(ClientRuntimeError.class);
        this.tested.handleClientError(error);
        ((EventSourceMock)Mockito.verify(this.sessionOpenedEventMock, (VerificationMode)Mockito.times((int)0))).fire(Matchers.any(SessionOpenedEvent.class));
        ((EventSourceMock)Mockito.verify(this.sessionPausedEventMock, (VerificationMode)Mockito.times((int)0))).fire(Matchers.any(SessionPausedEvent.class));
        ((EventSourceMock)Mockito.verify(this.sessionResumedEventMock, (VerificationMode)Mockito.times((int)0))).fire(Matchers.any(SessionResumedEvent.class));
        ((EventSourceMock)Mockito.verify(this.sessionErrorEventMock, (VerificationMode)Mockito.times((int)1))).fire(Matchers.any(OnSessionErrorEvent.class));
        ((EventSourceMock)Mockito.verify(this.sessionDestroyedEventMock, (VerificationMode)Mockito.times((int)0))).fire(Matchers.any(SessionDestroyedEvent.class));
    }

    @Test
    public void testHandleClientCommandError() {
        this.tested.current = this.session;
        CommandException error = (CommandException)Mockito.mock(CommandException.class);
        this.tested.handleCommandError(error);
        ((EventSourceMock)Mockito.verify(this.sessionOpenedEventMock, (VerificationMode)Mockito.times((int)0))).fire(Matchers.any(SessionOpenedEvent.class));
        ((EventSourceMock)Mockito.verify(this.sessionPausedEventMock, (VerificationMode)Mockito.times((int)0))).fire(Matchers.any(SessionPausedEvent.class));
        ((EventSourceMock)Mockito.verify(this.sessionResumedEventMock, (VerificationMode)Mockito.times((int)0))).fire(Matchers.any(SessionResumedEvent.class));
        ((EventSourceMock)Mockito.verify(this.sessionErrorEventMock, (VerificationMode)Mockito.times((int)1))).fire(Matchers.any(OnSessionErrorEvent.class));
        ((EventSourceMock)Mockito.verify(this.sessionDestroyedEventMock, (VerificationMode)Mockito.times((int)0))).fire(Matchers.any(SessionDestroyedEvent.class));
    }
}

