/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.canvas;

import java.util.Optional;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.stunner.core.api.DefinitionManager;
import org.kie.workbench.common.stunner.core.client.ShapeSet;
import org.kie.workbench.common.stunner.core.client.api.ShapeManager;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvas;
import org.kie.workbench.common.stunner.core.client.canvas.BaseCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.Layer;
import org.kie.workbench.common.stunner.core.client.command.CanvasCommandResultBuilder;
import org.kie.workbench.common.stunner.core.client.shape.ElementShape;
import org.kie.workbench.common.stunner.core.client.shape.MutationContext;
import org.kie.workbench.common.stunner.core.client.shape.Shape;
import org.kie.workbench.common.stunner.core.client.shape.factory.ShapeFactory;
import org.kie.workbench.common.stunner.core.client.shape.view.ShapeView;
import org.kie.workbench.common.stunner.core.command.CommandResult;
import org.kie.workbench.common.stunner.core.definition.adapter.AdapterManager;
import org.kie.workbench.common.stunner.core.definition.adapter.DefinitionAdapter;
import org.kie.workbench.common.stunner.core.definition.adapter.DefinitionSetRuleAdapter;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.diagram.Metadata;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandExecutionContext;
import org.kie.workbench.common.stunner.core.graph.content.definition.Definition;
import org.kie.workbench.common.stunner.core.graph.processing.index.Index;
import org.kie.workbench.common.stunner.core.graph.util.GraphUtils;
import org.kie.workbench.common.stunner.core.registry.definition.TypeDefinitionSetRegistry;
import org.kie.workbench.common.stunner.core.rule.EmptyRuleSet;
import org.kie.workbench.common.stunner.core.rule.RuleManager;
import org.kie.workbench.common.stunner.core.rule.RuleSet;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.ParameterizedCommand;

@RunWith(value=MockitoJUnitRunner.class)
public class BaseCanvasHandlerTest {
    private static final String PARENT_ID = "p1";
    private static final String CANDIDATE_ID = "c1";
    private static final String SHAPE_FACTORY_ID = "factory1";
    private static final RuleSet RULE_SET = new EmptyRuleSet();
    @Mock
    DefinitionManager definitionManager;
    @Mock
    AdapterManager adapterManager;
    @Mock
    TypeDefinitionSetRegistry definitionSetRegistry;
    @Mock
    DefinitionAdapter definitionAdapter;
    @Mock
    DefinitionSetRuleAdapter definitionSetRuleAdapter;
    @Mock
    GraphUtils graphUtils;
    @Mock
    ShapeManager shapeManager;
    @Mock
    RuleManager ruleManager;
    @Mock
    Index<?, ?> graphIndex;
    @Mock
    GraphCommandExecutionContext commandExecutionContext;
    @Mock
    ShapeSet shapeSet;
    @Mock
    ShapeFactory shapeFactory;
    @Mock
    Diagram diagram;
    @Mock
    Metadata metadata;
    @Mock
    AbstractCanvas canvas;
    @Mock
    Layer layer;
    @Mock
    ElementShape parentShape;
    @Mock
    ElementShape shape;
    @Mock
    ShapeView shapeView;
    @Mock
    Element parent;
    @Mock
    Node<?, Edge> candidate;
    @Mock
    Definition candidateContent;
    @Mock
    Object defSet;
    @Mock
    Object defBean;
    private BaseCanvasHandlerStub tested;

    @Before
    public void setup() throws Exception {
        Mockito.when((Object)this.definitionManager.adapters()).thenReturn((Object)this.adapterManager);
        Mockito.when((Object)this.definitionManager.definitionSets()).thenReturn((Object)this.definitionSetRegistry);
        Mockito.when((Object)this.adapterManager.forDefinition()).thenReturn((Object)this.definitionAdapter);
        Mockito.when((Object)this.adapterManager.forRules()).thenReturn((Object)this.definitionSetRuleAdapter);
        Mockito.when((Object)this.definitionSetRegistry.getDefinitionSetByType((Class)Matchers.any(Class.class))).thenReturn(this.defSet);
        Mockito.when((Object)this.definitionSetRuleAdapter.getRuleSet(Matchers.eq((Object)this.defSet))).thenReturn((Object)RULE_SET);
        Mockito.when((Object)this.shapeManager.getShapeSet((String)Matchers.eq((Object)SHAPE_FACTORY_ID))).thenReturn((Object)this.shapeSet);
        Mockito.when((Object)this.shapeSet.getShapeFactory()).thenReturn((Object)this.shapeFactory);
        Mockito.when((Object)this.shape.getShapeView()).thenReturn((Object)this.shapeView);
        Mockito.when((Object)this.shape.getUUID()).thenReturn((Object)CANDIDATE_ID);
        Mockito.when((Object)this.parent.getUUID()).thenReturn((Object)PARENT_ID);
        Mockito.when((Object)this.candidate.getUUID()).thenReturn((Object)CANDIDATE_ID);
        Mockito.when((Object)this.candidate.getContent()).thenReturn((Object)this.candidateContent);
        Mockito.when((Object)this.candidateContent.getDefinition()).thenReturn(this.defBean);
        Mockito.when((Object)this.canvas.getLayer()).thenReturn((Object)this.layer);
        Mockito.when((Object)this.canvas.getShape((String)Matchers.eq((Object)PARENT_ID))).thenReturn((Object)this.parentShape);
        Mockito.when((Object)this.canvas.getShape((String)Matchers.eq((Object)CANDIDATE_ID))).thenReturn((Object)this.shape);
        Mockito.when((Object)this.diagram.getMetadata()).thenReturn((Object)this.metadata);
        Mockito.when((Object)this.metadata.getDefinitionSetId()).thenReturn((Object)"ds1");
        this.tested = (BaseCanvasHandlerStub)((Object)Mockito.spy((Object)((Object)new BaseCanvasHandlerStub())));
        this.tested.handle(this.canvas);
        Assert.assertEquals((Object)this.canvas, (Object)this.tested.getCanvas());
    }

    @Test
    public void testDraw() {
        ParameterizedCommand callback = (ParameterizedCommand)Mockito.mock(ParameterizedCommand.class);
        this.tested.draw(this.diagram, callback);
        Assert.assertEquals((Object)this.diagram, (Object)this.tested.getDiagram());
        ((BaseCanvasHandlerStub)((Object)Mockito.verify((Object)((Object)this.tested), (VerificationMode)Mockito.times((int)1)))).draw((ParameterizedCommand)Matchers.eq((Object)callback));
    }

    @Test
    public void testRegister() {
        this.tested.register((Shape)this.shape, (Element)this.candidate, false);
        ((AbstractCanvas)Mockito.verify((Object)this.canvas, (VerificationMode)Mockito.times((int)1))).addShape((Shape)Matchers.eq((Object)this.shape));
        ((AbstractCanvas)Mockito.verify((Object)this.canvas, (VerificationMode)Mockito.times((int)1))).draw();
    }

    @Test
    public void testDeregister() {
        this.tested.deregister((Shape)this.shape, (Element)this.candidate, false);
        ((AbstractCanvas)Mockito.verify((Object)this.canvas, (VerificationMode)Mockito.times((int)1))).deleteShape((Shape)Matchers.eq((Object)this.shape));
        ((AbstractCanvas)Mockito.verify((Object)this.canvas, (VerificationMode)Mockito.times((int)1))).draw();
    }

    @Test
    public void testAddShape() {
        this.tested.addShape((Shape)this.shape);
        ((AbstractCanvas)Mockito.verify((Object)this.canvas, (VerificationMode)Mockito.times((int)1))).addShape((Shape)Matchers.eq((Object)this.shape));
    }

    @Test
    public void testRemoveShape() {
        this.tested.removeShape((Shape)this.shape);
        ((AbstractCanvas)Mockito.verify((Object)this.canvas, (VerificationMode)Mockito.times((int)1))).deleteShape((Shape)Matchers.eq((Object)this.shape));
    }

    @Test
    public void testApplyMutation() {
        MutationContext mutationContext = MutationContext.STATIC;
        this.tested.applyElementMutation(this.shape, (Element)this.candidate, true, true, mutationContext);
        ((ElementShape)Mockito.verify((Object)this.shape, (VerificationMode)Mockito.times((int)1))).applyPosition((Element)Matchers.eq(this.candidate), (MutationContext)Matchers.eq((Object)mutationContext));
        ((ElementShape)Mockito.verify((Object)this.shape, (VerificationMode)Mockito.times((int)1))).applyProperties(Matchers.eq(this.candidate), (MutationContext)Matchers.eq((Object)mutationContext));
        ((AbstractCanvas)Mockito.verify((Object)this.canvas, (VerificationMode)Mockito.times((int)1))).draw();
    }

    @Test
    public void testAddChild() {
        Mockito.when((Object)this.metadata.getCanvasRootUUID()).thenReturn(null);
        ParameterizedCommand callback = (ParameterizedCommand)Mockito.mock(ParameterizedCommand.class);
        this.tested.draw(this.diagram, callback);
        this.tested.addChild(this.parent, (Element)this.candidate);
        ((AbstractCanvas)Mockito.verify((Object)this.canvas, (VerificationMode)Mockito.times((int)1))).addChildShape((Shape)Matchers.eq((Object)this.parentShape), (Shape)Matchers.eq((Object)this.shape));
    }

    @Test
    public void testAddChildToRoot() {
        Mockito.when((Object)this.metadata.getCanvasRootUUID()).thenReturn((Object)PARENT_ID);
        ParameterizedCommand callback = (ParameterizedCommand)Mockito.mock(ParameterizedCommand.class);
        this.tested.draw(this.diagram, callback);
        this.tested.addChild(this.parent, (Element)this.candidate);
        ((Layer)Mockito.verify((Object)this.layer, (VerificationMode)Mockito.times((int)1))).addShape(Matchers.eq((Object)this.shapeView));
    }

    @Test
    public void testRemoveChild() {
        Mockito.when((Object)this.metadata.getCanvasRootUUID()).thenReturn(null);
        ParameterizedCommand callback = (ParameterizedCommand)Mockito.mock(ParameterizedCommand.class);
        this.tested.draw(this.diagram, callback);
        this.tested.removeChild(this.parent, (Element)this.candidate);
        ((AbstractCanvas)Mockito.verify((Object)this.canvas, (VerificationMode)Mockito.times((int)1))).deleteChildShape((Shape)Matchers.eq((Object)this.parentShape), (Shape)Matchers.eq((Object)this.shape));
    }

    @Test
    public void testDeleteChildFromRoot() {
        Mockito.when((Object)this.metadata.getCanvasRootUUID()).thenReturn((Object)PARENT_ID);
        ParameterizedCommand callback = (ParameterizedCommand)Mockito.mock(ParameterizedCommand.class);
        this.tested.draw(this.diagram, callback);
        this.tested.removeChild(this.parent, (Element)this.candidate);
        ((Layer)Mockito.verify((Object)this.layer, (VerificationMode)Mockito.times((int)1))).removeShape(Matchers.eq((Object)this.shapeView));
    }

    @Test
    public void getElementAtWhenCanvasHasShapeAtPosition() {
        Optional<Object> oShape = Optional.of(Mockito.mock(Shape.class));
        Index index = (Index)Mockito.mock(Index.class);
        Node n = (Node)Mockito.mock(Node.class);
        Mockito.when((Object)this.canvas.getShapeAt(Mockito.anyDouble(), Mockito.anyDouble())).thenReturn(oShape);
        Mockito.when((Object)this.commandExecutionContext.getGraphIndex()).thenReturn((Object)index);
        Mockito.when((Object)index.getNode(Mockito.anyString())).thenReturn((Object)n);
        Optional oElement = this.tested.getElementAt(0.0, 0.0);
        Assert.assertTrue((boolean)oElement.isPresent());
    }

    @Test
    public void getElementAtWhenCanvasDoesNotHaveShapeAtPosition() {
        Optional oShape = Optional.empty();
        Index index = (Index)Mockito.mock(Index.class);
        Mockito.when((Object)this.canvas.getShapeAt(Mockito.anyDouble(), Mockito.anyDouble())).thenReturn(oShape);
        Mockito.when((Object)this.commandExecutionContext.getGraphIndex()).thenReturn((Object)index);
        Optional oElement = this.tested.getElementAt(0.0, 0.0);
        Assert.assertFalse((boolean)oElement.isPresent());
    }

    @Test
    public void testDock() {
        Mockito.when((Object)this.metadata.getCanvasRootUUID()).thenReturn(null);
        ParameterizedCommand callback = (ParameterizedCommand)Mockito.mock(ParameterizedCommand.class);
        this.tested.draw(this.diagram, callback);
        this.tested.dock(this.parent, (Element)this.candidate);
        ((AbstractCanvas)Mockito.verify((Object)this.canvas, (VerificationMode)Mockito.times((int)1))).dock((Shape)Matchers.eq((Object)this.parentShape), (Shape)Matchers.eq((Object)this.shape));
    }

    @Test
    public void testUndock() {
        Mockito.when((Object)this.metadata.getCanvasRootUUID()).thenReturn(null);
        ParameterizedCommand callback = (ParameterizedCommand)Mockito.mock(ParameterizedCommand.class);
        this.tested.draw(this.diagram, callback);
        this.tested.undock(this.parent, (Element)this.candidate);
        ((AbstractCanvas)Mockito.verify((Object)this.canvas, (VerificationMode)Mockito.times((int)1))).undock((Shape)Matchers.eq((Object)this.parentShape), (Shape)Matchers.isNull(), (Shape)Matchers.eq((Object)this.shape));
    }

    @Test
    public void testClear() {
        this.tested.clear();
        Assert.assertNull((Object)this.tested.getDiagram());
        ((BaseCanvasHandlerStub)((Object)Mockito.verify((Object)((Object)this.tested), (VerificationMode)Mockito.times((int)1)))).destroyGraphIndex((Command)Matchers.any(Command.class));
        ((AbstractCanvas)Mockito.verify((Object)this.canvas, (VerificationMode)Mockito.times((int)1))).clear();
    }

    @Test
    public void testDestroy() {
        this.tested.destroy();
        Assert.assertNull((Object)this.tested.getDiagram());
        ((BaseCanvasHandlerStub)((Object)Mockito.verify((Object)((Object)this.tested), (VerificationMode)Mockito.times((int)1)))).destroyGraphIndex((Command)Matchers.any(Command.class));
        ((AbstractCanvas)Mockito.verify((Object)this.canvas, (VerificationMode)Mockito.times((int)1))).destroy();
    }

    private class BaseCanvasHandlerStub
    extends BaseCanvasHandler<Diagram, AbstractCanvas> {
        public BaseCanvasHandlerStub() {
            super(BaseCanvasHandlerTest.this.definitionManager, BaseCanvasHandlerTest.this.graphUtils, BaseCanvasHandlerTest.this.shapeManager);
        }

        public RuleManager getRuleManager() {
            return BaseCanvasHandlerTest.this.ruleManager;
        }

        protected void buildGraphIndex(Command loadCallback) {
            loadCallback.execute();
        }

        public void draw(ParameterizedCommand<CommandResult<?>> loadCallback) {
            loadCallback.execute((Object)CanvasCommandResultBuilder.SUCCESS);
        }

        protected void destroyGraphIndex(Command loadCallback) {
        }

        public Index<?, ?> getGraphIndex() {
            return BaseCanvasHandlerTest.this.graphIndex;
        }

        public GraphCommandExecutionContext getGraphExecutionContext() {
            return BaseCanvasHandlerTest.this.commandExecutionContext;
        }
    }
}

