/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.canvas;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.stunner.core.client.canvas.TransformImpl;
import org.kie.workbench.common.stunner.core.graph.content.view.Point2D;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class TransformImplTest {
    private static final Point2D translate = new Point2D(10.0, 20.0);
    private static final Point2D scale = new Point2D(2.0, 5.0);
    private TransformImpl tested;

    @Before
    public void setup() throws Exception {
        this.tested = new TransformImpl(translate, scale);
    }

    @Test
    public void testGetTranslate() {
        Point2D t = this.tested.getTranslate();
        Assert.assertEquals((Object)translate, (Object)t);
    }

    @Test
    public void testGetScale() {
        Point2D s = this.tested.getScale();
        Assert.assertEquals((Object)scale, (Object)s);
    }

    @Test
    public void testTranform() {
        Point2D t = this.tested.transform(1.0, 1.0);
        Assert.assertEquals((double)12.0, (double)t.getX(), (double)0.0);
        Assert.assertEquals((double)25.0, (double)t.getY(), (double)0.0);
        Point2D t1 = this.tested.transform(2.0, 2.0);
        Assert.assertEquals((double)14.0, (double)t1.getX(), (double)0.0);
        Assert.assertEquals((double)30.0, (double)t1.getY(), (double)0.0);
    }
}

