/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.canvas.command;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.command.AbstractCanvasCommandTest;
import org.kie.workbench.common.stunner.core.client.canvas.command.AddCanvasConnectorCommand;
import org.kie.workbench.common.stunner.core.client.shape.EdgeShape;
import org.kie.workbench.common.stunner.core.client.shape.MutationContext;
import org.kie.workbench.common.stunner.core.client.shape.Shape;
import org.kie.workbench.common.stunner.core.client.shape.view.ShapeView;
import org.kie.workbench.common.stunner.core.command.CommandResult;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class AddCanvasConnectorCommandTest
extends AbstractCanvasCommandTest {
    private static final String EDGE_ID = "e1";
    private static final String SOURCE_ID = "s1";
    @Mock
    private Edge candidate;
    @Mock
    private Node source;
    @Mock
    private EdgeShape candidateShape;
    @Mock
    private Shape sourceShape;
    @Mock
    private ShapeView sourceShapeView;
    private AddCanvasConnectorCommand tested;

    @Override
    @Before
    public void setup() throws Exception {
        super.setup();
        Mockito.when((Object)this.candidate.getUUID()).thenReturn((Object)EDGE_ID);
        Mockito.when((Object)this.source.getUUID()).thenReturn((Object)SOURCE_ID);
        Mockito.when((Object)this.candidate.getSourceNode()).thenReturn((Object)this.source);
        Mockito.when((Object)this.canvas.getShape((String)Matchers.eq((Object)EDGE_ID))).thenReturn((Object)this.candidateShape);
        Mockito.when((Object)this.canvas.getShape((String)Matchers.eq((Object)SOURCE_ID))).thenReturn((Object)this.sourceShape);
        Mockito.when((Object)this.sourceShape.getShapeView()).thenReturn((Object)this.sourceShapeView);
        this.tested = new AddCanvasConnectorCommand(this.candidate, "ssid1");
    }

    @Test
    public void testExecute() {
        CommandResult result = this.tested.execute(this.canvasHandler);
        Assert.assertNotEquals((Object)CommandResult.Type.ERROR, (Object)result.getType());
        ((AbstractCanvasHandler)Mockito.verify((Object)this.canvasHandler, (VerificationMode)Mockito.times((int)1))).register((String)Matchers.eq((Object)"ssid1"), (Element)Matchers.eq((Object)this.candidate));
        ((AbstractCanvasHandler)Mockito.verify((Object)this.canvasHandler, (VerificationMode)Mockito.times((int)1))).applyElementMutation((Element)Matchers.eq((Object)this.candidate), (MutationContext)Matchers.any(MutationContext.class));
        ((EdgeShape)Mockito.verify((Object)this.candidateShape, (VerificationMode)Mockito.times((int)1))).applyConnections((Edge)Matchers.eq((Object)this.candidate), (ShapeView)Matchers.eq((Object)this.sourceShapeView), (ShapeView)Matchers.eq(null), (MutationContext)Matchers.any(MutationContext.class));
        ((AbstractCanvasHandler)Mockito.verify((Object)this.canvasHandler, (VerificationMode)Mockito.times((int)1))).notifyCanvasElementUpdated((Element)Matchers.eq((Object)this.source));
    }
}

