/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.canvas.command;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.stunner.core.client.canvas.command.AbstractCanvasCommandTest;
import org.kie.workbench.common.stunner.core.client.canvas.command.AddCanvasConnectorCommand;
import org.kie.workbench.common.stunner.core.client.canvas.command.AddConnectorCommand;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.view.Magnet;
import org.kie.workbench.common.stunner.core.graph.content.view.MagnetImpl;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class AddConnectorCommandTest
extends AbstractCanvasCommandTest {
    private static final String EDGE_ID = "e1";
    private static final String SOURCE_ID = "s1";
    private static final Magnet MAGNET = MagnetImpl.Builder.build((Magnet.MagnetType)Magnet.MagnetType.OUTGOING);
    @Mock
    private Edge candidate;
    @Mock
    private Node source;
    private AddConnectorCommand tested;

    @Override
    @Before
    public void setup() throws Exception {
        super.setup();
        Mockito.when((Object)this.candidate.getUUID()).thenReturn((Object)EDGE_ID);
        Mockito.when((Object)this.source.getUUID()).thenReturn((Object)SOURCE_ID);
        Mockito.when((Object)this.candidate.getSourceNode()).thenReturn((Object)this.source);
        this.tested = new AddConnectorCommand(this.source, this.candidate, MAGNET, "ssid1");
    }

    @Test
    public void testGetGraphCommand() {
        org.kie.workbench.common.stunner.core.graph.command.impl.AddConnectorCommand graphCommand = (org.kie.workbench.common.stunner.core.graph.command.impl.AddConnectorCommand)this.tested.newGraphCommand(this.canvasHandler);
        Assert.assertNotNull((Object)graphCommand);
        Assert.assertEquals((Object)this.candidate, (Object)graphCommand.getEdge());
        Assert.assertEquals((Object)this.source, (Object)graphCommand.getSourceNode());
        Assert.assertEquals((Object)MAGNET, (Object)graphCommand.getMagnet());
    }

    @Test
    public void testGetCanvasCommand() {
        AddCanvasConnectorCommand canvasCommand = (AddCanvasConnectorCommand)this.tested.newCanvasCommand(this.canvasHandler);
        Assert.assertNotNull((Object)canvasCommand);
        Assert.assertEquals((Object)this.candidate, (Object)canvasCommand.getCandidate());
        Assert.assertEquals((Object)"ssid1", (Object)canvasCommand.getShapeSetId());
    }
}

