/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.canvas.command;

import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.command.AbstractCanvasCommand;
import org.kie.workbench.common.stunner.core.client.canvas.command.AbstractCanvasCommandTest;
import org.kie.workbench.common.stunner.core.client.canvas.command.AbstractCanvasGraphCommand;
import org.kie.workbench.common.stunner.core.client.service.ClientFactoryService;
import org.kie.workbench.common.stunner.core.command.Command;
import org.kie.workbench.common.stunner.core.command.CommandResult;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandExecutionContext;
import org.kie.workbench.common.stunner.core.rule.RuleViolation;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class CanvasCommandHasGraphTest
extends AbstractCanvasCommandTest {
    @Mock
    GraphCommandExecutionContext graphCommandExecutionContext;
    @Mock
    Command<GraphCommandExecutionContext, RuleViolation> graphCommand;
    @Mock
    AbstractCanvasCommand canvasCommand;
    @Mock
    ClientFactoryService clientFactoryService;
    @Mock
    CommandResult<RuleViolation> successGraphCommandResult;
    @Mock
    CommandResult<RuleViolation> failedGraphCommandResult;
    private HasGraphCommandStub tested;

    @Override
    @Before
    public void setup() throws Exception {
        super.setup();
        Mockito.when((Object)this.canvasHandler.getGraphExecutionContext()).thenReturn((Object)this.graphCommandExecutionContext);
        Mockito.when((Object)this.successGraphCommandResult.getType()).thenReturn((Object)CommandResult.Type.INFO);
        Mockito.when((Object)this.successGraphCommandResult.getViolations()).thenReturn(null);
        Mockito.when((Object)this.failedGraphCommandResult.getType()).thenReturn((Object)CommandResult.Type.ERROR);
        this.tested = new HasGraphCommandStub();
    }

    @Test
    public void testAllowSuccess() {
        Mockito.when((Object)this.graphCommand.allow(Matchers.any(GraphCommandExecutionContext.class))).thenReturn(this.successGraphCommandResult);
        this.tested.allow(this.canvasHandler);
        ((Command)Mockito.verify(this.graphCommand, (VerificationMode)Mockito.times((int)1))).allow(Matchers.any(GraphCommandExecutionContext.class));
        ((AbstractCanvasCommand)Mockito.verify((Object)this.canvasCommand, (VerificationMode)Mockito.times((int)1))).allow((AbstractCanvasHandler)Matchers.eq((Object)this.canvasHandler));
        ((Command)Mockito.verify(this.graphCommand, (VerificationMode)Mockito.times((int)0))).execute(Matchers.any(GraphCommandExecutionContext.class));
        ((AbstractCanvasCommand)Mockito.verify((Object)this.canvasCommand, (VerificationMode)Mockito.times((int)0))).execute(Matchers.eq((Object)this.canvasHandler));
    }

    @Test
    public void testAllowFailed() {
        Mockito.when((Object)this.graphCommand.allow(Matchers.any(GraphCommandExecutionContext.class))).thenReturn(this.failedGraphCommandResult);
        this.tested.allow(this.canvasHandler);
        ((Command)Mockito.verify(this.graphCommand, (VerificationMode)Mockito.times((int)1))).allow(Matchers.any(GraphCommandExecutionContext.class));
        ((AbstractCanvasCommand)Mockito.verify((Object)this.canvasCommand, (VerificationMode)Mockito.times((int)0))).allow((AbstractCanvasHandler)Matchers.eq((Object)this.canvasHandler));
        ((Command)Mockito.verify(this.graphCommand, (VerificationMode)Mockito.times((int)0))).execute(Matchers.any(GraphCommandExecutionContext.class));
        ((AbstractCanvasCommand)Mockito.verify((Object)this.canvasCommand, (VerificationMode)Mockito.times((int)0))).execute(Matchers.eq((Object)this.canvasHandler));
    }

    @Test
    public void testExecuteSuccess() {
        Mockito.when((Object)this.graphCommand.allow(Matchers.any(GraphCommandExecutionContext.class))).thenReturn(this.successGraphCommandResult);
        Mockito.when((Object)this.graphCommand.execute(Matchers.any(GraphCommandExecutionContext.class))).thenReturn(this.successGraphCommandResult);
        this.tested.execute(this.canvasHandler);
        ((Command)Mockito.verify(this.graphCommand, (VerificationMode)Mockito.times((int)1))).execute(Matchers.any(GraphCommandExecutionContext.class));
        ((AbstractCanvasCommand)Mockito.verify((Object)this.canvasCommand, (VerificationMode)Mockito.times((int)1))).execute(Matchers.eq((Object)this.canvasHandler));
        ((Command)Mockito.verify(this.graphCommand, (VerificationMode)Mockito.times((int)0))).allow(Matchers.any(GraphCommandExecutionContext.class));
        ((AbstractCanvasCommand)Mockito.verify((Object)this.canvasCommand, (VerificationMode)Mockito.times((int)0))).allow((AbstractCanvasHandler)Matchers.eq((Object)this.canvasHandler));
    }

    @Test
    public void testExecuteFailed() {
        Mockito.when((Object)this.graphCommand.allow(Matchers.any(GraphCommandExecutionContext.class))).thenReturn(this.failedGraphCommandResult);
        Mockito.when((Object)this.graphCommand.execute(Matchers.any(GraphCommandExecutionContext.class))).thenReturn(this.failedGraphCommandResult);
        this.tested.execute(this.canvasHandler);
        ((Command)Mockito.verify(this.graphCommand, (VerificationMode)Mockito.times((int)1))).execute(Matchers.any(GraphCommandExecutionContext.class));
        ((AbstractCanvasCommand)Mockito.verify((Object)this.canvasCommand, (VerificationMode)Mockito.times((int)0))).execute(Matchers.eq((Object)this.canvasHandler));
        ((Command)Mockito.verify(this.graphCommand, (VerificationMode)Mockito.times((int)0))).allow(Matchers.any(GraphCommandExecutionContext.class));
        ((AbstractCanvasCommand)Mockito.verify((Object)this.canvasCommand, (VerificationMode)Mockito.times((int)0))).allow((AbstractCanvasHandler)Matchers.eq((Object)this.canvasHandler));
    }

    @Test
    public void testAllowNoGraphContext() {
        Mockito.when((Object)this.canvasHandler.getGraphExecutionContext()).thenReturn(null);
        this.tested.allow(this.canvasHandler);
        ((Command)Mockito.verify(this.graphCommand, (VerificationMode)Mockito.times((int)0))).allow(Matchers.any(GraphCommandExecutionContext.class));
        ((AbstractCanvasCommand)Mockito.verify((Object)this.canvasCommand, (VerificationMode)Mockito.times((int)1))).allow((AbstractCanvasHandler)Matchers.eq((Object)this.canvasHandler));
        ((Command)Mockito.verify(this.graphCommand, (VerificationMode)Mockito.times((int)0))).execute(Matchers.any(GraphCommandExecutionContext.class));
        ((AbstractCanvasCommand)Mockito.verify((Object)this.canvasCommand, (VerificationMode)Mockito.times((int)0))).execute(Matchers.eq((Object)this.canvasHandler));
    }

    @Test
    public void testExecuteNoGraphContext() {
        Mockito.when((Object)this.canvasHandler.getGraphExecutionContext()).thenReturn(null);
        this.tested.execute(this.canvasHandler);
        ((Command)Mockito.verify(this.graphCommand, (VerificationMode)Mockito.times((int)0))).execute(Matchers.any(GraphCommandExecutionContext.class));
        ((AbstractCanvasCommand)Mockito.verify((Object)this.canvasCommand, (VerificationMode)Mockito.times((int)1))).execute(Matchers.eq((Object)this.canvasHandler));
        ((Command)Mockito.verify(this.graphCommand, (VerificationMode)Mockito.times((int)0))).allow(Matchers.any(GraphCommandExecutionContext.class));
        ((AbstractCanvasCommand)Mockito.verify((Object)this.canvasCommand, (VerificationMode)Mockito.times((int)0))).allow((AbstractCanvasHandler)Matchers.eq((Object)this.canvasHandler));
    }

    private class HasGraphCommandStub
    extends AbstractCanvasGraphCommand {
        private HasGraphCommandStub() {
        }

        protected Command<GraphCommandExecutionContext, RuleViolation> newGraphCommand(AbstractCanvasHandler context) {
            return CanvasCommandHasGraphTest.this.graphCommand;
        }

        protected AbstractCanvasCommand newCanvasCommand(AbstractCanvasHandler context) {
            return CanvasCommandHasGraphTest.this.canvasCommand;
        }
    }
}

