/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.canvas.command;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.command.AbstractCanvasCommandTest;
import org.kie.workbench.common.stunner.core.client.canvas.command.DeleteCanvasConnectorCommand;
import org.kie.workbench.common.stunner.core.command.CommandResult;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class DeleteCanvasConnectorCommandTest
extends AbstractCanvasCommandTest {
    private static final String EDGE_ID = "e1";
    private static final String SOURCE_ID = "s1";
    @Mock
    private Edge candidate;
    @Mock
    private Node source;
    @Mock
    private Node target;
    private DeleteCanvasConnectorCommand tested;

    @Override
    @Before
    public void setup() throws Exception {
        super.setup();
        Mockito.when((Object)this.candidate.getUUID()).thenReturn((Object)EDGE_ID);
        Mockito.when((Object)this.source.getUUID()).thenReturn((Object)SOURCE_ID);
        Mockito.when((Object)this.candidate.getSourceNode()).thenReturn((Object)this.source);
        Mockito.when((Object)this.candidate.getTargetNode()).thenReturn((Object)this.target);
        this.tested = new DeleteCanvasConnectorCommand(this.candidate);
    }

    @Test
    public void testExecute() {
        CommandResult result = this.tested.execute(this.canvasHandler);
        Assert.assertNotEquals((Object)CommandResult.Type.ERROR, (Object)result.getType());
        ((AbstractCanvasHandler)Mockito.verify((Object)this.canvasHandler, (VerificationMode)Mockito.times((int)1))).deregister((Element)Matchers.eq((Object)this.candidate));
        ((AbstractCanvasHandler)Mockito.verify((Object)this.canvasHandler, (VerificationMode)Mockito.times((int)1))).notifyCanvasElementUpdated((Element)Matchers.eq((Object)this.source));
        ((AbstractCanvasHandler)Mockito.verify((Object)this.canvasHandler, (VerificationMode)Mockito.times((int)1))).notifyCanvasElementUpdated((Element)Matchers.eq((Object)this.target));
    }
}

