/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.canvas.controls;

import java.util.ArrayList;
import java.util.List;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvas;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.controls.CanvasControl;
import org.kie.workbench.common.stunner.core.client.canvas.controls.CanvasControlRegistrationHandler;
import org.kie.workbench.common.stunner.core.client.canvas.listener.CanvasElementListener;
import org.kie.workbench.common.stunner.core.client.canvas.listener.CanvasShapeListener;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class CanvasControlRegistrationHandlerTest {
    private static final int CTROLS_SIZE = 5;
    @Mock
    AbstractCanvas canvas;
    @Mock
    AbstractCanvasHandler canvasHandler;
    private CanvasControlRegistrationHandler tested;
    private final List<CanvasControl<AbstractCanvas>> canvasControls = new ArrayList<CanvasControl<AbstractCanvas>>(5);
    private final List<CanvasControl<AbstractCanvasHandler>> canvasHandlerControls = new ArrayList<CanvasControl<AbstractCanvasHandler>>(5);

    @Before
    public void setup() throws Exception {
        this.tested = new CanvasControlRegistrationHandler(this.canvas, this.canvasHandler);
        for (int x = 0; x < 5; ++x) {
            this.canvasControls.add((CanvasControl<AbstractCanvas>)Mockito.mock(CanvasControl.class));
            this.canvasHandlerControls.add((CanvasControl<AbstractCanvasHandler>)Mockito.mock(CanvasControl.class));
        }
        this.canvasControls.forEach(arg_0 -> ((CanvasControlRegistrationHandler)this.tested).registerCanvasControl(arg_0));
        this.canvasHandlerControls.forEach(arg_0 -> ((CanvasControlRegistrationHandler)this.tested).registerCanvasHandlerControl(arg_0));
    }

    @Test
    public void testEnable() {
        this.tested.enable();
        ((AbstractCanvas)Mockito.verify((Object)this.canvas, (VerificationMode)Mockito.times((int)1))).addRegistrationListener((CanvasShapeListener)Matchers.any(CanvasShapeListener.class));
        ((AbstractCanvasHandler)Mockito.verify((Object)this.canvasHandler, (VerificationMode)Mockito.times((int)1))).addRegistrationListener((CanvasElementListener)Matchers.any(CanvasElementListener.class));
        this.canvasControls.forEach(c -> ((CanvasControl)Mockito.verify((Object)c, (VerificationMode)Mockito.times((int)1))).enable(Matchers.eq((Object)this.canvas)));
        this.canvasHandlerControls.forEach(c -> ((CanvasControl)Mockito.verify((Object)c, (VerificationMode)Mockito.times((int)1))).enable(Matchers.eq((Object)this.canvasHandler)));
    }

    @Test
    public void testDisable() {
        this.tested.enable();
        this.tested.disable();
        ((AbstractCanvas)Mockito.verify((Object)this.canvas, (VerificationMode)Mockito.times((int)1))).addRegistrationListener((CanvasShapeListener)Matchers.any(CanvasShapeListener.class));
        ((AbstractCanvasHandler)Mockito.verify((Object)this.canvasHandler, (VerificationMode)Mockito.times((int)1))).addRegistrationListener((CanvasElementListener)Matchers.any(CanvasElementListener.class));
        ((AbstractCanvas)Mockito.verify((Object)this.canvas, (VerificationMode)Mockito.times((int)1))).removeRegistrationListener((CanvasShapeListener)Matchers.any(CanvasShapeListener.class));
        ((AbstractCanvasHandler)Mockito.verify((Object)this.canvasHandler, (VerificationMode)Mockito.times((int)1))).removeRegistrationListener((CanvasElementListener)Matchers.any(CanvasElementListener.class));
        this.canvasControls.forEach(c -> {
            ((CanvasControl)Mockito.verify((Object)c, (VerificationMode)Mockito.times((int)1))).enable(Matchers.eq((Object)this.canvas));
            ((CanvasControl)Mockito.verify((Object)c, (VerificationMode)Mockito.times((int)1))).disable();
        });
        this.canvasHandlerControls.forEach(c -> {
            ((CanvasControl)Mockito.verify((Object)c, (VerificationMode)Mockito.times((int)1))).enable(Matchers.eq((Object)this.canvasHandler));
            ((CanvasControl)Mockito.verify((Object)c, (VerificationMode)Mockito.times((int)1))).disable();
        });
    }

    @Test
    public void testClear() {
        this.tested.enable();
        this.tested.clear();
        ((AbstractCanvas)Mockito.verify((Object)this.canvas, (VerificationMode)Mockito.times((int)1))).addRegistrationListener((CanvasShapeListener)Matchers.any(CanvasShapeListener.class));
        ((AbstractCanvasHandler)Mockito.verify((Object)this.canvasHandler, (VerificationMode)Mockito.times((int)1))).addRegistrationListener((CanvasElementListener)Matchers.any(CanvasElementListener.class));
        ((AbstractCanvas)Mockito.verify((Object)this.canvas, (VerificationMode)Mockito.times((int)1))).removeRegistrationListener((CanvasShapeListener)Matchers.any(CanvasShapeListener.class));
        ((AbstractCanvasHandler)Mockito.verify((Object)this.canvasHandler, (VerificationMode)Mockito.times((int)1))).removeRegistrationListener((CanvasElementListener)Matchers.any(CanvasElementListener.class));
        this.canvasControls.forEach(c -> {
            ((CanvasControl)Mockito.verify((Object)c, (VerificationMode)Mockito.times((int)1))).enable(Matchers.eq((Object)this.canvas));
            ((CanvasControl)Mockito.verify((Object)c, (VerificationMode)Mockito.times((int)1))).disable();
        });
        this.canvasHandlerControls.forEach(c -> {
            ((CanvasControl)Mockito.verify((Object)c, (VerificationMode)Mockito.times((int)1))).enable(Matchers.eq((Object)this.canvasHandler));
            ((CanvasControl)Mockito.verify((Object)c, (VerificationMode)Mockito.times((int)1))).disable();
        });
    }

    @Test
    public void testDestroy() {
        this.tested.enable();
        this.tested.destroy();
        ((AbstractCanvas)Mockito.verify((Object)this.canvas, (VerificationMode)Mockito.times((int)1))).addRegistrationListener((CanvasShapeListener)Matchers.any(CanvasShapeListener.class));
        ((AbstractCanvasHandler)Mockito.verify((Object)this.canvasHandler, (VerificationMode)Mockito.times((int)1))).addRegistrationListener((CanvasElementListener)Matchers.any(CanvasElementListener.class));
        ((AbstractCanvas)Mockito.verify((Object)this.canvas, (VerificationMode)Mockito.times((int)1))).removeRegistrationListener((CanvasShapeListener)Matchers.any(CanvasShapeListener.class));
        ((AbstractCanvas)Mockito.verify((Object)this.canvas, (VerificationMode)Mockito.times((int)1))).clearRegistrationListeners();
        ((AbstractCanvasHandler)Mockito.verify((Object)this.canvasHandler, (VerificationMode)Mockito.times((int)1))).clearRegistrationListeners();
        this.canvasControls.forEach(c -> {
            ((CanvasControl)Mockito.verify((Object)c, (VerificationMode)Mockito.times((int)1))).enable(Matchers.eq((Object)this.canvas));
            ((CanvasControl)Mockito.verify((Object)c, (VerificationMode)Mockito.times((int)1))).disable();
        });
        this.canvasHandlerControls.forEach(c -> {
            ((CanvasControl)Mockito.verify((Object)c, (VerificationMode)Mockito.times((int)1))).enable(Matchers.eq((Object)this.canvasHandler));
            ((CanvasControl)Mockito.verify((Object)c, (VerificationMode)Mockito.times((int)1))).disable();
        });
    }
}

