/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.canvas.util;

import java.util.LinkedList;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvas;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.util.CanvasHighlight;
import org.kie.workbench.common.stunner.core.client.shape.Shape;
import org.kie.workbench.common.stunner.core.client.shape.ShapeState;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.rule.violations.RuleViolationImpl;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class CanvasHighlightTest {
    public static final String ID1 = "n1";
    public static final String ID2 = "n2";
    @Mock
    AbstractCanvasHandler handler;
    @Mock
    AbstractCanvas canvas;
    @Mock
    Node node1;
    @Mock
    Node node2;
    @Mock
    Shape shape1;
    @Mock
    Shape shape2;
    private CanvasHighlight tested;

    @Before
    public void setup() throws Exception {
        Mockito.when((Object)this.handler.getCanvas()).thenReturn((Object)this.canvas);
        Mockito.when((Object)this.handler.getAbstractCanvas()).thenReturn((Object)this.canvas);
        Mockito.when((Object)this.node1.getUUID()).thenReturn((Object)ID1);
        Mockito.when((Object)this.node2.getUUID()).thenReturn((Object)ID2);
        Mockito.when((Object)this.canvas.getShape((String)Matchers.eq((Object)ID1))).thenReturn((Object)this.shape1);
        Mockito.when((Object)this.canvas.getShape((String)Matchers.eq((Object)ID2))).thenReturn((Object)this.shape2);
        this.tested = new CanvasHighlight(this.handler);
    }

    @Test
    public void testSingle() {
        this.tested.none((Element)this.node1);
        ((Shape)Mockito.verify((Object)this.shape1, (VerificationMode)Mockito.times((int)1))).applyState((ShapeState)Matchers.eq((Object)ShapeState.NONE));
        ((Shape)Mockito.verify((Object)this.shape2, (VerificationMode)Mockito.times((int)0))).applyState((ShapeState)Matchers.any(ShapeState.class));
        ((AbstractCanvas)Mockito.verify((Object)this.canvas, (VerificationMode)Mockito.times((int)1))).draw();
    }

    @Test
    public void testMultiple() {
        this.tested.none((Element)this.node1);
        this.tested.invalid((Element)this.node2);
        ((Shape)Mockito.verify((Object)this.shape1, (VerificationMode)Mockito.times((int)1))).applyState((ShapeState)Matchers.eq((Object)ShapeState.NONE));
        ((Shape)Mockito.verify((Object)this.shape2, (VerificationMode)Mockito.times((int)1))).applyState((ShapeState)Matchers.eq((Object)ShapeState.INVALID));
        ((AbstractCanvas)Mockito.verify((Object)this.canvas, (VerificationMode)Mockito.times((int)2))).draw();
    }

    @Test
    public void testViolations() {
        LinkedList<RuleViolationImpl> violations = new LinkedList<RuleViolationImpl>();
        RuleViolationImpl v1 = new RuleViolationImpl("m1");
        v1.setUUID(ID1);
        RuleViolationImpl v2 = new RuleViolationImpl("m2");
        v2.setUUID(ID2);
        violations.add(v1);
        violations.add(v2);
        this.tested.invalid(violations);
        ((Shape)Mockito.verify((Object)this.shape1, (VerificationMode)Mockito.times((int)1))).applyState((ShapeState)Matchers.eq((Object)ShapeState.INVALID));
        ((Shape)Mockito.verify((Object)this.shape2, (VerificationMode)Mockito.times((int)1))).applyState((ShapeState)Matchers.eq((Object)ShapeState.INVALID));
        ((AbstractCanvas)Mockito.verify((Object)this.canvas, (VerificationMode)Mockito.times((int)1))).draw();
    }

    @Test
    public void testUnhighLight() {
        this.tested.highLight((Element)this.node1);
        this.tested.invalid((Element)this.node2);
        this.tested.unhighLight();
        ((Shape)Mockito.verify((Object)this.shape1, (VerificationMode)Mockito.times((int)1))).applyState((ShapeState)Matchers.eq((Object)ShapeState.HIGHLIGHT));
        ((Shape)Mockito.verify((Object)this.shape1, (VerificationMode)Mockito.times((int)1))).applyState((ShapeState)Matchers.eq((Object)ShapeState.NONE));
        ((Shape)Mockito.verify((Object)this.shape2, (VerificationMode)Mockito.times((int)1))).applyState((ShapeState)Matchers.eq((Object)ShapeState.INVALID));
        ((Shape)Mockito.verify((Object)this.shape2, (VerificationMode)Mockito.times((int)1))).applyState((ShapeState)Matchers.eq((Object)ShapeState.NONE));
        ((AbstractCanvas)Mockito.verify((Object)this.canvas, (VerificationMode)Mockito.times((int)3))).draw();
    }

    @Test
    public void testDestroy() {
        this.tested.highLight((Element)this.node1);
        this.tested.invalid((Element)this.node2);
        this.tested.destroy();
        this.tested.unhighLight();
        ((Shape)Mockito.verify((Object)this.shape1, (VerificationMode)Mockito.times((int)1))).applyState((ShapeState)Matchers.eq((Object)ShapeState.HIGHLIGHT));
        ((Shape)Mockito.verify((Object)this.shape1, (VerificationMode)Mockito.times((int)0))).applyState((ShapeState)Matchers.eq((Object)ShapeState.NONE));
        ((Shape)Mockito.verify((Object)this.shape2, (VerificationMode)Mockito.times((int)1))).applyState((ShapeState)Matchers.eq((Object)ShapeState.INVALID));
        ((Shape)Mockito.verify((Object)this.shape2, (VerificationMode)Mockito.times((int)0))).applyState((ShapeState)Matchers.eq((Object)ShapeState.NONE));
        ((AbstractCanvas)Mockito.verify((Object)this.canvas, (VerificationMode)Mockito.times((int)2))).draw();
    }
}

