/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.service;

import org.jboss.errai.common.client.api.Caller;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.stunner.core.client.api.ClientFactoryManager;
import org.kie.workbench.common.stunner.core.client.service.ClientFactoryService;
import org.kie.workbench.common.stunner.core.client.service.ServiceCallback;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.diagram.Metadata;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.service.FactoryService;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.mocks.CallerMock;

@RunWith(value=MockitoJUnitRunner.class)
public class ClientFactoryServicesTest {
    @Mock
    ClientFactoryManager clientFactoryManager;
    @Mock
    FactoryService factoryService;
    @Mock
    Metadata metadata;
    private Caller<FactoryService> factoryServiceCaller;
    private ClientFactoryService tested;

    @Before
    public void setup() throws Exception {
        this.factoryServiceCaller = new CallerMock((Object)this.factoryService);
        this.tested = new ClientFactoryService(this.clientFactoryManager, this.factoryServiceCaller);
    }

    @Test
    public void testNewDefinitionLocal() {
        String id = "id1";
        ServiceCallback callback = (ServiceCallback)Mockito.mock(ServiceCallback.class);
        Object def = Mockito.mock(Object.class);
        Mockito.when((Object)this.clientFactoryManager.newDefinition((String)Matchers.eq((Object)id))).thenReturn(def);
        this.tested.newDefinition(id, callback);
        ((ServiceCallback)Mockito.verify((Object)callback, (VerificationMode)Mockito.times((int)1))).onSuccess(Matchers.eq((Object)def));
        ((ClientFactoryManager)Mockito.verify((Object)this.clientFactoryManager, (VerificationMode)Mockito.times((int)1))).newDefinition((String)Matchers.eq((Object)id));
        ((ClientFactoryManager)Mockito.verify((Object)this.clientFactoryManager, (VerificationMode)Mockito.times((int)0))).newDefinition((Class)Mockito.any(Class.class));
        ((FactoryService)Mockito.verify((Object)this.factoryService, (VerificationMode)Mockito.times((int)0))).newDefinition(Matchers.anyString());
        ((FactoryService)Mockito.verify((Object)this.factoryService, (VerificationMode)Mockito.times((int)0))).newDefinition((Class)Mockito.any(Class.class));
    }

    @Test
    public void testNewDefinitionRemote() {
        String id = "id1";
        ServiceCallback callback = (ServiceCallback)Mockito.mock(ServiceCallback.class);
        Object def = Mockito.mock(Object.class);
        Mockito.when((Object)this.clientFactoryManager.newDefinition((String)Matchers.eq((Object)id))).thenReturn(null);
        Mockito.when((Object)this.factoryService.newDefinition((String)Matchers.eq((Object)id))).thenReturn(def);
        this.tested.newDefinition(id, callback);
        ((ServiceCallback)Mockito.verify((Object)callback, (VerificationMode)Mockito.times((int)1))).onSuccess(Matchers.eq((Object)def));
        ((ClientFactoryManager)Mockito.verify((Object)this.clientFactoryManager, (VerificationMode)Mockito.times((int)1))).newDefinition((String)Matchers.eq((Object)id));
        ((ClientFactoryManager)Mockito.verify((Object)this.clientFactoryManager, (VerificationMode)Mockito.times((int)0))).newDefinition((Class)Mockito.any(Class.class));
        ((FactoryService)Mockito.verify((Object)this.factoryService, (VerificationMode)Mockito.times((int)1))).newDefinition((String)Matchers.eq((Object)id));
        ((FactoryService)Mockito.verify((Object)this.factoryService, (VerificationMode)Mockito.times((int)0))).newDefinition((Class)Mockito.any(Class.class));
    }

    @Test
    public void testNewDefinitionByTpeLocal() {
        ServiceCallback callback = (ServiceCallback)Mockito.mock(ServiceCallback.class);
        MyType def = (MyType)Mockito.mock(MyType.class);
        Mockito.when((Object)this.clientFactoryManager.newDefinition((Class)Matchers.eq(MyType.class))).thenReturn((Object)def);
        this.tested.newDefinition(MyType.class, callback);
        ((ServiceCallback)Mockito.verify((Object)callback, (VerificationMode)Mockito.times((int)1))).onSuccess(Matchers.eq((Object)def));
        ((ClientFactoryManager)Mockito.verify((Object)this.clientFactoryManager, (VerificationMode)Mockito.times((int)0))).newDefinition(Matchers.anyString());
        ((ClientFactoryManager)Mockito.verify((Object)this.clientFactoryManager, (VerificationMode)Mockito.times((int)1))).newDefinition((Class)Matchers.eq(MyType.class));
        ((FactoryService)Mockito.verify((Object)this.factoryService, (VerificationMode)Mockito.times((int)0))).newDefinition(Matchers.anyString());
        ((FactoryService)Mockito.verify((Object)this.factoryService, (VerificationMode)Mockito.times((int)0))).newDefinition((Class)Mockito.any(Class.class));
    }

    @Test
    public void testNewDefinitionByTpeRemote() {
        ServiceCallback callback = (ServiceCallback)Mockito.mock(ServiceCallback.class);
        MyType def = (MyType)Mockito.mock(MyType.class);
        Mockito.when((Object)this.clientFactoryManager.newDefinition((Class)Matchers.eq(MyType.class))).thenReturn(null);
        Mockito.when((Object)this.factoryService.newDefinition((Class)Matchers.eq(MyType.class))).thenReturn((Object)def);
        this.tested.newDefinition(MyType.class, callback);
        ((ServiceCallback)Mockito.verify((Object)callback, (VerificationMode)Mockito.times((int)1))).onSuccess(Matchers.eq((Object)def));
        ((ClientFactoryManager)Mockito.verify((Object)this.clientFactoryManager, (VerificationMode)Mockito.times((int)0))).newDefinition(Matchers.anyString());
        ((ClientFactoryManager)Mockito.verify((Object)this.clientFactoryManager, (VerificationMode)Mockito.times((int)1))).newDefinition((Class)Matchers.eq(MyType.class));
        ((FactoryService)Mockito.verify((Object)this.factoryService, (VerificationMode)Mockito.times((int)0))).newDefinition(Matchers.anyString());
        ((FactoryService)Mockito.verify((Object)this.factoryService, (VerificationMode)Mockito.times((int)1))).newDefinition((Class)Matchers.eq(MyType.class));
    }

    @Test
    public void testNewElementLocal() {
        String id = "id1";
        String defSetId = "defSet1";
        ServiceCallback callback = (ServiceCallback)Mockito.mock(ServiceCallback.class);
        Element def = (Element)Mockito.mock(Element.class);
        Mockito.when((Object)this.clientFactoryManager.newElement((String)Matchers.eq((Object)id), (String)Matchers.eq((Object)defSetId))).thenReturn((Object)def);
        this.tested.newElement(id, defSetId, callback);
        ((ServiceCallback)Mockito.verify((Object)callback, (VerificationMode)Mockito.times((int)1))).onSuccess(Matchers.eq((Object)def));
        ((ClientFactoryManager)Mockito.verify((Object)this.clientFactoryManager, (VerificationMode)Mockito.times((int)1))).newElement((String)Matchers.eq((Object)id), (String)Matchers.eq((Object)defSetId));
        ((ClientFactoryManager)Mockito.verify((Object)this.clientFactoryManager, (VerificationMode)Mockito.times((int)0))).newElement(Matchers.anyString(), (Class)Mockito.any(Class.class));
        ((FactoryService)Mockito.verify((Object)this.factoryService, (VerificationMode)Mockito.times((int)0))).newElement(Matchers.anyString(), Matchers.anyString());
        ((FactoryService)Mockito.verify((Object)this.factoryService, (VerificationMode)Mockito.times((int)0))).newElement(Matchers.anyString(), (Class)Mockito.any(Class.class));
    }

    @Test
    public void testNewElementRemote() {
        String id = "id1";
        String defSetId = "defSet1";
        ServiceCallback callback = (ServiceCallback)Mockito.mock(ServiceCallback.class);
        Element def = (Element)Mockito.mock(Element.class);
        Mockito.when((Object)this.clientFactoryManager.newElement((String)Matchers.eq((Object)id), (String)Matchers.eq((Object)defSetId))).thenReturn(null);
        Mockito.when((Object)this.factoryService.newElement((String)Matchers.eq((Object)id), (String)Matchers.eq((Object)defSetId))).thenReturn((Object)def);
        this.tested.newElement(id, defSetId, callback);
        ((ServiceCallback)Mockito.verify((Object)callback, (VerificationMode)Mockito.times((int)1))).onSuccess(Matchers.eq((Object)def));
        ((ClientFactoryManager)Mockito.verify((Object)this.clientFactoryManager, (VerificationMode)Mockito.times((int)1))).newElement((String)Matchers.eq((Object)id), (String)Matchers.eq((Object)defSetId));
        ((ClientFactoryManager)Mockito.verify((Object)this.clientFactoryManager, (VerificationMode)Mockito.times((int)0))).newElement(Matchers.anyString(), (Class)Mockito.any(Class.class));
        ((FactoryService)Mockito.verify((Object)this.factoryService, (VerificationMode)Mockito.times((int)1))).newElement((String)Matchers.eq((Object)id), (String)Matchers.eq((Object)defSetId));
        ((FactoryService)Mockito.verify((Object)this.factoryService, (VerificationMode)Mockito.times((int)0))).newElement(Matchers.anyString(), (Class)Mockito.any(Class.class));
    }

    @Test
    public void testNewElementByTpeLocal() {
        String id = "id1";
        ServiceCallback callback = (ServiceCallback)Mockito.mock(ServiceCallback.class);
        Element def = (Element)Mockito.mock(Element.class);
        Mockito.when((Object)this.clientFactoryManager.newElement((String)Matchers.eq((Object)id), (Class)Matchers.eq(MyType.class))).thenReturn((Object)def);
        this.tested.newElement(id, MyType.class, callback);
        ((ServiceCallback)Mockito.verify((Object)callback, (VerificationMode)Mockito.times((int)1))).onSuccess(Matchers.eq((Object)def));
        ((ClientFactoryManager)Mockito.verify((Object)this.clientFactoryManager, (VerificationMode)Mockito.times((int)0))).newElement(Matchers.anyString(), Matchers.anyString());
        ((ClientFactoryManager)Mockito.verify((Object)this.clientFactoryManager, (VerificationMode)Mockito.times((int)1))).newElement(Matchers.anyString(), (Class)Matchers.eq(MyType.class));
        ((FactoryService)Mockito.verify((Object)this.factoryService, (VerificationMode)Mockito.times((int)0))).newElement(Matchers.anyString(), Matchers.anyString());
        ((FactoryService)Mockito.verify((Object)this.factoryService, (VerificationMode)Mockito.times((int)0))).newElement(Matchers.anyString(), (Class)Mockito.any(Class.class));
    }

    @Test
    public void testNewElementByTpeRemote() {
        String id = "id1";
        ServiceCallback callback = (ServiceCallback)Mockito.mock(ServiceCallback.class);
        Element def = (Element)Mockito.mock(Element.class);
        Mockito.when((Object)this.clientFactoryManager.newElement((String)Matchers.eq((Object)id), (Class)Matchers.eq(MyType.class))).thenReturn(null);
        Mockito.when((Object)this.factoryService.newElement((String)Matchers.eq((Object)id), (Class)Matchers.eq(MyType.class))).thenReturn((Object)def);
        this.tested.newElement(id, MyType.class, callback);
        ((ServiceCallback)Mockito.verify((Object)callback, (VerificationMode)Mockito.times((int)1))).onSuccess(Matchers.eq((Object)def));
        ((ClientFactoryManager)Mockito.verify((Object)this.clientFactoryManager, (VerificationMode)Mockito.times((int)0))).newElement(Matchers.anyString(), Matchers.anyString());
        ((ClientFactoryManager)Mockito.verify((Object)this.clientFactoryManager, (VerificationMode)Mockito.times((int)1))).newElement(Matchers.anyString(), (Class)Matchers.eq(MyType.class));
        ((FactoryService)Mockito.verify((Object)this.factoryService, (VerificationMode)Mockito.times((int)0))).newElement(Matchers.anyString(), Matchers.anyString());
        ((FactoryService)Mockito.verify((Object)this.factoryService, (VerificationMode)Mockito.times((int)1))).newElement(Matchers.anyString(), (Class)Mockito.any(Class.class));
    }

    @Test
    public void testNewDiagramLocal() {
        String id = "id1";
        String name = "name1";
        ServiceCallback callback = (ServiceCallback)Mockito.mock(ServiceCallback.class);
        Diagram def = (Diagram)Mockito.mock(Diagram.class);
        Mockito.when((Object)this.clientFactoryManager.newDiagram((String)Matchers.eq((Object)name), (String)Matchers.eq((Object)id), (Metadata)Mockito.any(Metadata.class))).thenReturn((Object)def);
        this.tested.newDiagram(name, id, this.metadata, callback);
        ((ServiceCallback)Mockito.verify((Object)callback, (VerificationMode)Mockito.times((int)1))).onSuccess(Matchers.eq((Object)def));
        ((ClientFactoryManager)Mockito.verify((Object)this.clientFactoryManager, (VerificationMode)Mockito.times((int)1))).newDiagram((String)Matchers.eq((Object)name), (String)Matchers.eq((Object)id), (Metadata)Matchers.eq((Object)this.metadata));
        ((ClientFactoryManager)Mockito.verify((Object)this.clientFactoryManager, (VerificationMode)Mockito.times((int)0))).newDiagram(Matchers.anyString(), (Class)Mockito.any(Class.class), (Metadata)Mockito.any(Metadata.class));
        ((FactoryService)Mockito.verify((Object)this.factoryService, (VerificationMode)Mockito.times((int)0))).newDiagram(Matchers.anyString(), Matchers.anyString(), (Metadata)Mockito.any(Metadata.class));
        ((FactoryService)Mockito.verify((Object)this.factoryService, (VerificationMode)Mockito.times((int)0))).newDiagram(Matchers.anyString(), (Class)Mockito.any(Class.class), (Metadata)Mockito.any(Metadata.class));
    }

    @Test
    public void testNewDiagramRemote() {
        String id = "id1";
        String name = "name1";
        ServiceCallback callback = (ServiceCallback)Mockito.mock(ServiceCallback.class);
        Diagram def = (Diagram)Mockito.mock(Diagram.class);
        Mockito.when((Object)this.clientFactoryManager.newDiagram((String)Matchers.eq((Object)name), (String)Matchers.eq((Object)id), (Metadata)Mockito.any(Metadata.class))).thenReturn(null);
        Mockito.when((Object)this.factoryService.newDiagram((String)Matchers.eq((Object)name), (String)Matchers.eq((Object)id), (Metadata)Mockito.any(Metadata.class))).thenReturn((Object)def);
        this.tested.newDiagram(name, id, this.metadata, callback);
        ((ServiceCallback)Mockito.verify((Object)callback, (VerificationMode)Mockito.times((int)1))).onSuccess(Matchers.eq((Object)def));
        ((ClientFactoryManager)Mockito.verify((Object)this.clientFactoryManager, (VerificationMode)Mockito.times((int)1))).newDiagram((String)Matchers.eq((Object)name), (String)Matchers.eq((Object)id), (Metadata)Mockito.any(Metadata.class));
        ((ClientFactoryManager)Mockito.verify((Object)this.clientFactoryManager, (VerificationMode)Mockito.times((int)0))).newDiagram(Matchers.anyString(), (Class)Mockito.any(Class.class), (Metadata)Mockito.any(Metadata.class));
        ((FactoryService)Mockito.verify((Object)this.factoryService, (VerificationMode)Mockito.times((int)1))).newDiagram((String)Matchers.eq((Object)name), (String)Matchers.eq((Object)id), (Metadata)Mockito.any(Metadata.class));
        ((FactoryService)Mockito.verify((Object)this.factoryService, (VerificationMode)Mockito.times((int)0))).newDiagram(Matchers.anyString(), (Class)Mockito.any(Class.class), (Metadata)Mockito.any(Metadata.class));
    }

    @Test
    public void testNewDiagramByTpeLocal() {
        String name = "name1";
        ServiceCallback callback = (ServiceCallback)Mockito.mock(ServiceCallback.class);
        Diagram def = (Diagram)Mockito.mock(Diagram.class);
        Mockito.when((Object)this.clientFactoryManager.newDiagram((String)Matchers.eq((Object)name), (Class)Matchers.eq(MyType.class), (Metadata)Mockito.any(Metadata.class))).thenReturn((Object)def);
        this.tested.newDiagram(name, MyType.class, this.metadata, callback);
        ((ServiceCallback)Mockito.verify((Object)callback, (VerificationMode)Mockito.times((int)1))).onSuccess(Matchers.eq((Object)def));
        ((ClientFactoryManager)Mockito.verify((Object)this.clientFactoryManager, (VerificationMode)Mockito.times((int)0))).newDiagram(Matchers.anyString(), Matchers.anyString(), (Metadata)Mockito.any(Metadata.class));
        ((ClientFactoryManager)Mockito.verify((Object)this.clientFactoryManager, (VerificationMode)Mockito.times((int)1))).newDiagram(Matchers.anyString(), (Class)Matchers.eq(MyType.class), (Metadata)Mockito.any(Metadata.class));
        ((FactoryService)Mockito.verify((Object)this.factoryService, (VerificationMode)Mockito.times((int)0))).newDiagram(Matchers.anyString(), Matchers.anyString(), (Metadata)Mockito.any(Metadata.class));
        ((FactoryService)Mockito.verify((Object)this.factoryService, (VerificationMode)Mockito.times((int)0))).newDiagram(Matchers.anyString(), (Class)Mockito.any(Class.class), (Metadata)Mockito.any(Metadata.class));
    }

    @Test
    public void testNewDiagramByTpeRemote() {
        String name = "name1";
        ServiceCallback callback = (ServiceCallback)Mockito.mock(ServiceCallback.class);
        Diagram def = (Diagram)Mockito.mock(Diagram.class);
        Mockito.when((Object)this.clientFactoryManager.newDiagram((String)Matchers.eq((Object)name), (Class)Matchers.eq(MyType.class), (Metadata)Mockito.any(Metadata.class))).thenReturn(null);
        Mockito.when((Object)this.factoryService.newDiagram((String)Matchers.eq((Object)name), (Class)Matchers.eq(MyType.class), (Metadata)Mockito.any(Metadata.class))).thenReturn((Object)def);
        this.tested.newDiagram(name, MyType.class, this.metadata, callback);
        ((ServiceCallback)Mockito.verify((Object)callback, (VerificationMode)Mockito.times((int)1))).onSuccess(Matchers.eq((Object)def));
        ((ClientFactoryManager)Mockito.verify((Object)this.clientFactoryManager, (VerificationMode)Mockito.times((int)0))).newDiagram(Matchers.anyString(), Matchers.anyString(), (Metadata)Mockito.any(Metadata.class));
        ((ClientFactoryManager)Mockito.verify((Object)this.clientFactoryManager, (VerificationMode)Mockito.times((int)1))).newDiagram(Matchers.anyString(), (Class)Matchers.eq(MyType.class), (Metadata)Mockito.any(Metadata.class));
        ((FactoryService)Mockito.verify((Object)this.factoryService, (VerificationMode)Mockito.times((int)0))).newDiagram(Matchers.anyString(), Matchers.anyString(), (Metadata)Mockito.any(Metadata.class));
        ((FactoryService)Mockito.verify((Object)this.factoryService, (VerificationMode)Mockito.times((int)1))).newDiagram(Matchers.anyString(), (Class)Mockito.any(Class.class), (Metadata)Mockito.any(Metadata.class));
    }

    private class MyType {
        private MyType() {
        }
    }
}

