/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.shape.impl;

import java.util.function.Predicate;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.stunner.core.client.shape.ConnectorViewStub;
import org.kie.workbench.common.stunner.core.client.shape.MutationContext;
import org.kie.workbench.common.stunner.core.client.shape.ShapeState;
import org.kie.workbench.common.stunner.core.client.shape.impl.ConnectorShape;
import org.kie.workbench.common.stunner.core.client.shape.impl.ShapeStateHelper;
import org.kie.workbench.common.stunner.core.client.shape.view.IsConnector;
import org.kie.workbench.common.stunner.core.client.shape.view.ShapeView;
import org.kie.workbench.common.stunner.core.definition.shape.MutableShapeDef;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.content.Bounds;
import org.kie.workbench.common.stunner.core.graph.content.view.BoundImpl;
import org.kie.workbench.common.stunner.core.graph.content.view.BoundsImpl;
import org.kie.workbench.common.stunner.core.graph.content.view.Magnet;
import org.kie.workbench.common.stunner.core.graph.content.view.MagnetImpl;
import org.kie.workbench.common.stunner.core.graph.content.view.ViewConnectorImpl;
import org.kie.workbench.common.stunner.core.graph.impl.EdgeImpl;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class ConnectorShapeTest {
    @Mock
    private MutableShapeDef shapeDef;
    @Mock
    private ShapeStateHelper shapeStateHelper;
    private ConnectorShape tested;
    private ShapeView<?> shapeView;

    @Before
    public void setup() throws Exception {
        this.shapeView = (ShapeView)Mockito.spy((Object)new ConnectorViewStub());
        Mockito.when((Object)this.shapeStateHelper.save((Predicate)Matchers.any(Predicate.class))).thenReturn((Object)this.shapeStateHelper);
        this.tested = new ConnectorShape(this.shapeDef, this.shapeView, this.shapeStateHelper);
    }

    @Test
    public void testApplyState() {
        this.tested.applyState(ShapeState.NONE);
        ((ShapeStateHelper)Mockito.verify((Object)this.shapeStateHelper, (VerificationMode)Mockito.times((int)1))).save((Predicate)Matchers.any(Predicate.class));
        ((ShapeStateHelper)Mockito.verify((Object)this.shapeStateHelper, (VerificationMode)Mockito.times((int)1))).applyState((ShapeState)Matchers.eq((Object)ShapeState.NONE));
    }

    @Test
    public void testApplyConnections() {
        Object def = Mockito.mock(Object.class);
        EdgeImpl edge = new EdgeImpl("uuid1");
        ViewConnectorImpl content = new ViewConnectorImpl(def, (Bounds)new BoundsImpl(new BoundImpl(Double.valueOf(0.0), Double.valueOf(0.0)), new BoundImpl(Double.valueOf(15.0), Double.valueOf(40.0))));
        MagnetImpl sourceMagnet = MagnetImpl.Builder.build((Magnet.MagnetType)Magnet.MagnetType.OUTGOING);
        MagnetImpl targetMagnet = MagnetImpl.Builder.build((Magnet.MagnetType)Magnet.MagnetType.INCOMING);
        content.setSourceMagnet((Magnet)sourceMagnet);
        content.setTargetMagnet((Magnet)targetMagnet);
        edge.setContent((Object)content);
        ShapeView source = (ShapeView)Mockito.mock(ShapeView.class);
        ShapeView target = (ShapeView)Mockito.mock(ShapeView.class);
        this.tested.applyConnections((Edge)edge, source, target, MutationContext.STATIC);
        ((IsConnector)Mockito.verify((Object)((IsConnector)this.shapeView), (VerificationMode)Mockito.times((int)1))).connect((ShapeView)Matchers.eq((Object)source), (Magnet)Matchers.eq((Object)sourceMagnet), (ShapeView)Matchers.eq((Object)target), (Magnet)Matchers.eq((Object)targetMagnet), Matchers.eq((boolean)true), Matchers.eq((boolean)false));
    }
}

