/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.shape.impl;

import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.stunner.core.client.shape.MutationContext;
import org.kie.workbench.common.stunner.core.client.shape.ShapeState;
import org.kie.workbench.common.stunner.core.client.shape.ShapeViewExtStub;
import org.kie.workbench.common.stunner.core.client.shape.impl.NodeShapeImpl;
import org.kie.workbench.common.stunner.core.client.shape.view.HasFillGradient;
import org.kie.workbench.common.stunner.core.client.shape.view.HasTitle;
import org.kie.workbench.common.stunner.core.client.shape.view.ShapeView;
import org.kie.workbench.common.stunner.core.definition.shape.MutableShapeDef;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.Bounds;
import org.kie.workbench.common.stunner.core.graph.content.view.BoundImpl;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class NodeShapeImplTest {
    private static final String COLOR = "c1";
    @Mock
    MutableShapeDef<Object> def;
    @Mock
    Node<View<Object>, Edge> element;
    @Mock
    Object definition;
    @Mock
    View<Object> content;
    @Mock
    Bounds bounds;
    private ShapeViewExtStub view;
    private NodeShapeImpl<Object, MutableShapeDef<Object>, ShapeView<?>> tested;

    @Before
    public void setup() throws Exception {
        Mockito.when((Object)this.def.getBackgroundColor(Mockito.any(Object.class))).thenReturn((Object)COLOR);
        Mockito.when((Object)this.def.getBackgroundAlpha(Mockito.any(Object.class))).thenReturn((Object)1.0);
        Mockito.when((Object)this.def.getBorderColor(Mockito.any(Object.class))).thenReturn((Object)COLOR);
        Mockito.when((Object)this.def.getBorderAlpha(Mockito.any(Object.class))).thenReturn((Object)1.0);
        Mockito.when((Object)this.def.getBorderSize(Mockito.any(Object.class))).thenReturn((Object)2.0);
        Mockito.when((Object)this.def.getFontFamily(Mockito.any(Object.class))).thenReturn((Object)COLOR);
        Mockito.when((Object)this.def.getFontColor(Mockito.any(Object.class))).thenReturn((Object)COLOR);
        Mockito.when((Object)this.def.getFontSize(Mockito.any(Object.class))).thenReturn((Object)1.0);
        Mockito.when((Object)this.def.getFontBorderSize(Mockito.any(Object.class))).thenReturn((Object)1.0);
        Mockito.when((Object)this.def.getFontPosition(Mockito.any(Object.class))).thenReturn((Object)HasTitle.Position.BOTTOM);
        Mockito.when((Object)this.def.getFontRotation(Mockito.any(Object.class))).thenReturn((Object)1.0);
        Mockito.when((Object)this.element.getContent()).thenReturn(this.content);
        Mockito.when((Object)this.content.getDefinition()).thenReturn(this.definition);
        Mockito.when((Object)this.content.getBounds()).thenReturn((Object)this.bounds);
        Mockito.when((Object)this.bounds.getUpperLeft()).thenReturn((Object)new BoundImpl(Double.valueOf(10.0), Double.valueOf(20.0)));
        Mockito.when((Object)this.bounds.getLowerRight()).thenReturn((Object)new BoundImpl(Double.valueOf(50.0), Double.valueOf(60.0)));
        this.view = (ShapeViewExtStub)Mockito.spy((Object)new ShapeViewExtStub());
        this.tested = new NodeShapeImpl(this.def, (ShapeView)this.view);
    }

    @Test
    public void testApplyPosition() {
        this.tested.applyPosition(this.element, MutationContext.STATIC);
        ((ShapeViewExtStub)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setShapeX(10.0);
        ((ShapeViewExtStub)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setShapeY(20.0);
    }

    @Test
    public void testApplyProperties() {
        this.tested.applyProperties(this.element, MutationContext.STATIC);
        ((ShapeViewExtStub)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setFillGradient((HasFillGradient.Type)Mockito.any(HasFillGradient.Type.class), (String)Mockito.eq((Object)COLOR), Mockito.anyString());
        ((ShapeViewExtStub)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setFillAlpha(Mockito.eq((double)1.0));
        ((ShapeViewExtStub)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setStrokeColor((String)Mockito.eq((Object)COLOR));
        ((ShapeViewExtStub)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setStrokeWidth(Mockito.eq((double)2.0));
        ((ShapeViewExtStub)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setStrokeAlpha(Mockito.eq((double)1.0));
    }

    @Test
    public void testApplyState() {
        this.tested.applyProperties(this.element, MutationContext.STATIC);
        this.tested.applyState(ShapeState.INVALID);
        ((ShapeViewExtStub)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setStrokeColor((String)Mockito.eq((Object)ShapeState.INVALID.getColor()));
        ((ShapeViewExtStub)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)2))).setStrokeWidth(Mockito.anyDouble());
        ((ShapeViewExtStub)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)2))).setStrokeAlpha(Mockito.eq((double)1.0));
    }

    @Test
    public void testChangeState() {
        this.tested.applyProperties(this.element, MutationContext.STATIC);
        this.tested.applyState(ShapeState.INVALID);
        this.tested.applyState(ShapeState.NONE);
        ((ShapeViewExtStub)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setStrokeColor((String)Mockito.eq((Object)ShapeState.INVALID.getColor()));
        ((ShapeViewExtStub)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)3))).setStrokeWidth(Mockito.anyDouble());
        ((ShapeViewExtStub)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setStrokeColor((String)Mockito.eq((Object)COLOR));
        ((ShapeViewExtStub)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)2))).setStrokeAlpha(Mockito.eq((double)1.0));
    }
}

