/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.shape.impl;

import java.util.function.Predicate;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.stunner.core.client.shape.Shape;
import org.kie.workbench.common.stunner.core.client.shape.ShapeState;
import org.kie.workbench.common.stunner.core.client.shape.ShapeViewExtStub;
import org.kie.workbench.common.stunner.core.client.shape.impl.ShapeImpl;
import org.kie.workbench.common.stunner.core.client.shape.impl.ShapeStateHelper;
import org.kie.workbench.common.stunner.core.client.shape.view.ShapeView;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class ShapeImplTest {
    @Mock
    private ShapeStateHelper shapeStateHelper;
    private ShapeViewExtStub view;
    private ShapeImpl<ShapeView> tested;

    @Before
    public void setup() throws Exception {
        Mockito.when((Object)this.shapeStateHelper.save((Predicate)Mockito.any(Predicate.class))).thenReturn((Object)this.shapeStateHelper);
        this.view = (ShapeViewExtStub)Mockito.spy((Object)new ShapeViewExtStub());
        this.tested = new ShapeImpl((ShapeView)this.view, this.shapeStateHelper);
        ((ShapeStateHelper)Mockito.verify((Object)this.shapeStateHelper, (VerificationMode)Mockito.times((int)1))).forShape((Shape)Mockito.eq(this.tested));
    }

    @Test
    public void testGetters() {
        Assert.assertEquals((Object)this.view, (Object)this.tested.getShapeView());
        Assert.assertEquals((Object)this.shapeStateHelper, (Object)this.tested.getShapeStateHelper());
    }

    @Test
    public void testUUID() {
        this.tested.setUUID("uuid1");
        Assert.assertEquals((Object)"uuid1", (Object)this.tested.getUUID());
    }

    @Test
    public void testApplyState() {
        this.tested.applyState(ShapeState.NONE);
        ((ShapeStateHelper)Mockito.verify((Object)this.shapeStateHelper, (VerificationMode)Mockito.times((int)1))).save((Predicate)Mockito.any(Predicate.class));
        ((ShapeStateHelper)Mockito.verify((Object)this.shapeStateHelper, (VerificationMode)Mockito.times((int)1))).applyState((ShapeState)Mockito.eq((Object)ShapeState.NONE));
    }

    @Test
    public void testAfterDraw() {
        this.tested.afterDraw();
        ((ShapeViewExtStub)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).moveTitleToTop();
    }

    @Test
    public void testDestroy() {
        this.tested.destroy();
        ((ShapeViewExtStub)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).destroy();
    }
}

