/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.util;

import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.stunner.core.TestingGraphInstanceBuilder;
import org.kie.workbench.common.stunner.core.TestingGraphMockHandler;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvas;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.CanvasHandler;
import org.kie.workbench.common.stunner.core.client.shape.EdgeShape;
import org.kie.workbench.common.stunner.core.client.shape.MutationContext;
import org.kie.workbench.common.stunner.core.client.shape.Shape;
import org.kie.workbench.common.stunner.core.client.shape.view.ShapeView;
import org.kie.workbench.common.stunner.core.client.util.ShapeUtils;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.processing.index.Index;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class ShapeUtilsTest {
    @Mock
    private AbstractCanvasHandler canvasHandler;
    @Mock
    private Index graphIndex;
    @Mock
    private AbstractCanvas canvas;
    @Mock
    private Shape<?> edge1Shape;
    @Mock
    private ShapeView<?> edge1ShapeView;
    @Mock
    private Shape<?> edge2Shape;
    @Mock
    private ShapeView<?> edge2ShapeView;
    private TestingGraphInstanceBuilder.TestGraph2 instance2;

    @Before
    public void setup() throws Exception {
        TestingGraphMockHandler graphTestHandler = new TestingGraphMockHandler();
        this.instance2 = TestingGraphInstanceBuilder.newGraph2((TestingGraphMockHandler)graphTestHandler);
        Mockito.when((Object)this.canvasHandler.getCanvas()).thenReturn((Object)this.canvas);
        Mockito.when((Object)this.canvasHandler.getGraphIndex()).thenReturn((Object)this.graphIndex);
        Mockito.when((Object)this.graphIndex.getGraph()).thenReturn((Object)this.instance2.graph);
        String e1 = this.instance2.edge1.getUUID();
        String e2 = this.instance2.edge2.getUUID();
        Mockito.when((Object)this.canvas.getShape((String)Matchers.eq((Object)e1))).thenReturn(this.edge1Shape);
        Mockito.when((Object)this.canvas.getShape((String)Matchers.eq((Object)e2))).thenReturn(this.edge2Shape);
        Mockito.when((Object)this.edge1Shape.getShapeView()).thenReturn(this.edge1ShapeView);
        Mockito.when((Object)this.edge2Shape.getShapeView()).thenReturn(this.edge2ShapeView);
    }

    @Test
    public void testApplyConnections() {
        Shape startNodeShape = (Shape)Mockito.mock(Shape.class);
        ShapeView startNodeShapeView = (ShapeView)Mockito.mock(ShapeView.class);
        Shape intermNodeShape = (Shape)Mockito.mock(Shape.class);
        ShapeView intermNodeShapeView = (ShapeView)Mockito.mock(ShapeView.class);
        EdgeShape edge1EdgeShape = (EdgeShape)Mockito.mock(EdgeShape.class);
        Mockito.when((Object)this.canvas.getShape((String)Matchers.eq((Object)this.instance2.startNode.getUUID()))).thenReturn((Object)startNodeShape);
        Mockito.when((Object)this.canvas.getShape((String)Matchers.eq((Object)this.instance2.intermNode.getUUID()))).thenReturn((Object)intermNodeShape);
        Mockito.when((Object)this.canvas.getShape((String)Matchers.eq((Object)this.instance2.edge1.getUUID()))).thenReturn((Object)edge1EdgeShape);
        Mockito.when((Object)startNodeShape.getShapeView()).thenReturn((Object)startNodeShapeView);
        Mockito.when((Object)intermNodeShape.getShapeView()).thenReturn((Object)intermNodeShapeView);
        Mockito.when((Object)edge1EdgeShape.getShapeView()).thenReturn(this.edge1ShapeView);
        ShapeUtils.applyConnections((Edge)this.instance2.edge1, (CanvasHandler)this.canvasHandler, (MutationContext)MutationContext.STATIC);
        ((EdgeShape)Mockito.verify((Object)edge1EdgeShape, (VerificationMode)Mockito.times((int)1))).applyConnections((Edge)Matchers.eq((Object)this.instance2.edge1), (ShapeView)Matchers.eq((Object)startNodeShapeView), (ShapeView)Matchers.eq((Object)intermNodeShapeView), (MutationContext)Matchers.eq((Object)MutationContext.STATIC));
    }

    @Test
    public void testMoveViewConnectorsToTop() {
        ShapeUtils.moveViewConnectorsToTop((AbstractCanvasHandler)this.canvasHandler, (Node)this.instance2.parentNode);
        ((ShapeView)Mockito.verify(this.edge1ShapeView, (VerificationMode)Mockito.times((int)1))).moveToTop();
        ((ShapeView)Mockito.verify(this.edge2ShapeView, (VerificationMode)Mockito.times((int)1))).moveToTop();
    }
}

