/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.canvas.command;

import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.command.AbstractCanvasGraphCommand;
import org.kie.workbench.common.stunner.core.client.canvas.command.CanvasUndockNodeCommand;
import org.kie.workbench.common.stunner.core.client.canvas.command.DeleteCanvasConnectorCommand;
import org.kie.workbench.common.stunner.core.client.canvas.command.DeleteCanvasNodeCommand;
import org.kie.workbench.common.stunner.core.client.canvas.command.RemoveCanvasChildCommand;
import org.kie.workbench.common.stunner.core.client.canvas.command.SetCanvasConnectionCommand;
import org.kie.workbench.common.stunner.core.client.command.CanvasViolation;
import org.kie.workbench.common.stunner.core.command.Command;
import org.kie.workbench.common.stunner.core.command.impl.CompositeCommand;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandExecutionContext;
import org.kie.workbench.common.stunner.core.graph.command.impl.SafeDeleteNodeCommand;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.kie.workbench.common.stunner.core.graph.content.view.ViewConnector;
import org.kie.workbench.common.stunner.core.rule.RuleViolation;

public class DeleteNodeCommand
extends AbstractCanvasGraphCommand {
    private final Node candidate;
    private final SafeDeleteNodeCommand.Options options;
    private transient CanvasDeleteProcessor deleteProcessor;

    public DeleteNodeCommand(Node candidate) {
        this(candidate, SafeDeleteNodeCommand.Options.defaults());
    }

    public DeleteNodeCommand(Node candidate, SafeDeleteNodeCommand.Options options) {
        this.candidate = candidate;
        this.options = options;
        this.deleteProcessor = new CanvasDeleteProcessor(options);
    }

    public Node getCandidate() {
        return this.candidate;
    }

    @Override
    protected Command<GraphCommandExecutionContext, RuleViolation> newGraphCommand(AbstractCanvasHandler context) {
        return new SafeDeleteNodeCommand(this.candidate, (SafeDeleteNodeCommand.SafeDeleteNodeCommandCallback)this.deleteProcessor, this.options);
    }

    @Override
    protected Command<AbstractCanvasHandler, CanvasViolation> newCanvasCommand(AbstractCanvasHandler context) {
        return this.deleteProcessor.getCommand();
    }

    CompositeCommand<AbstractCanvasHandler, CanvasViolation> getCommand() {
        return this.deleteProcessor.getCommand();
    }

    public static class CanvasDeleteProcessor
    implements SafeDeleteNodeCommand.SafeDeleteNodeCommandCallback {
        private transient CompositeCommand<AbstractCanvasHandler, CanvasViolation> command;
        private final SafeDeleteNodeCommand.Options options;

        public CanvasDeleteProcessor(SafeDeleteNodeCommand.Options options) {
            this.options = options;
            this.command = new CompositeCommand.Builder().reverse().build();
        }

        public void deleteCandidateConnector(Edge<? extends View<?>, Node> connector) {
            this.doDeleteConnector(connector);
        }

        public boolean deleteConnector(Edge<? extends View<?>, Node> connector) {
            return this.doDeleteConnector(connector);
        }

        public void setEdgeTargetNode(Node<? extends View<?>, Edge> targetNode, Edge<? extends ViewConnector<?>, Node> candidate) {
            this.getCommand().addCommand((Command)new SetCanvasConnectionCommand(candidate));
        }

        public void removeChild(Element<?> parent, Node<?, Edge> candidate) {
            this.getCommand().addCommand((Command)new RemoveCanvasChildCommand((Node)parent, candidate));
        }

        public void removeDock(Node<?, Edge> parent, Node<?, Edge> candidate) {
            this.getCommand().addCommand((Command)new CanvasUndockNodeCommand(parent, candidate));
        }

        public void deleteCandidateNode(Node<?, Edge> node) {
            this.doDeleteNode(node);
        }

        public boolean deleteNode(Node<?, Edge> node) {
            return this.doDeleteNode(node);
        }

        public CompositeCommand<AbstractCanvasHandler, CanvasViolation> getCommand() {
            return this.command;
        }

        public SafeDeleteNodeCommand.Options getOptions() {
            return this.options;
        }

        private boolean doDeleteNode(Node<?, Edge> node) {
            if (!this.options.getExclusions().contains(node.getUUID())) {
                this.getCommand().addCommand((Command)new DeleteCanvasNodeCommand(node));
                return true;
            }
            return false;
        }

        private boolean doDeleteConnector(Edge<? extends View<?>, Node> connector) {
            if (!this.options.getExclusions().contains(connector.getUUID())) {
                this.getCommand().addCommand((Command)new DeleteCanvasConnectorCommand(connector));
                return true;
            }
            return false;
        }
    }
}

