/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.canvas.controls.builder.impl;

import java.util.List;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.Default;
import javax.inject.Inject;
import org.kie.workbench.common.stunner.core.client.api.ClientDefinitionManager;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.controls.AbstractCanvasHandlerControl;
import org.kie.workbench.common.stunner.core.client.canvas.controls.builder.BuilderControl;
import org.kie.workbench.common.stunner.core.client.canvas.controls.builder.NodeBuilderControl;
import org.kie.workbench.common.stunner.core.client.canvas.controls.builder.impl.AbstractElementBuilderControl;
import org.kie.workbench.common.stunner.core.client.canvas.controls.builder.impl.Element;
import org.kie.workbench.common.stunner.core.client.canvas.controls.builder.impl.ElementBuilderControlImpl;
import org.kie.workbench.common.stunner.core.client.canvas.controls.builder.request.ElementBuildRequestImpl;
import org.kie.workbench.common.stunner.core.client.canvas.controls.builder.request.NodeBuildRequest;
import org.kie.workbench.common.stunner.core.client.command.CanvasCommandFactory;
import org.kie.workbench.common.stunner.core.client.command.CanvasViolation;
import org.kie.workbench.common.stunner.core.client.command.RequiresCommandManager;
import org.kie.workbench.common.stunner.core.client.service.ClientRuntimeError;
import org.kie.workbench.common.stunner.core.client.shape.EdgeShape;
import org.kie.workbench.common.stunner.core.client.shape.MutationContext;
import org.kie.workbench.common.stunner.core.client.shape.Shape;
import org.kie.workbench.common.stunner.core.command.Command;
import org.kie.workbench.common.stunner.core.command.CommandResult;
import org.kie.workbench.common.stunner.core.command.impl.CompositeCommand;
import org.kie.workbench.common.stunner.core.command.util.CommandUtils;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.view.Connection;
import org.kie.workbench.common.stunner.core.graph.content.view.Point2D;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.kie.workbench.common.stunner.core.graph.content.view.ViewConnector;

@Dependent
@Default
public class NodeBuilderControlImpl
extends AbstractCanvasHandlerControl<AbstractCanvasHandler>
implements NodeBuilderControl<AbstractCanvasHandler> {
    private final ClientDefinitionManager clientDefinitionManager;
    private final CanvasCommandFactory<AbstractCanvasHandler> commandFactory;
    private final AbstractElementBuilderControl elementBuilderControl;

    @Inject
    public NodeBuilderControlImpl(ClientDefinitionManager clientDefinitionManager, CanvasCommandFactory<AbstractCanvasHandler> commandFactory, @Default @Element AbstractElementBuilderControl elementBuilderControl) {
        this.clientDefinitionManager = clientDefinitionManager;
        this.commandFactory = commandFactory;
        this.elementBuilderControl = elementBuilderControl;
    }

    @Override
    protected void doInit() {
        this.elementBuilderControl.init(this.canvasHandler);
    }

    @Override
    protected void doDestroy() {
        this.elementBuilderControl.destroy();
    }

    public void setCommandManagerProvider(RequiresCommandManager.CommandManagerProvider<AbstractCanvasHandler> provider) {
        this.elementBuilderControl.setCommandManagerProvider(provider);
    }

    public boolean allows(NodeBuildRequest request) {
        double x = request.getX();
        double y = request.getY();
        Node node = request.getNode();
        if (null != node) {
            ElementBuildRequestImpl request1 = new ElementBuildRequestImpl(x, y, ((View)node.getContent()).getDefinition());
            return this.elementBuilderControl.allows(request1);
        }
        return false;
    }

    public void build(NodeBuildRequest request, final BuilderControl.BuildCallback buildCallback) {
        double x = request.getX();
        double y = request.getY();
        final Node node = request.getNode();
        final Edge inEdge = request.getInEdge();
        final Connection sourceConnection = request.getSourceConnection();
        final Connection targetConnection = request.getTargetConnection();
        if (null != node) {
            Object nodeDef = ((View)node.getContent()).getDefinition();
            String nodeId = this.clientDefinitionManager.adapters().forDefinition().getId(nodeDef);
            ElementBuilderControlImpl ebc = this.getElementBuilderControl();
            Node<View<?>, Edge> parent = ebc.getParent(x, y);
            Point2D childCoordinates = ebc.getChildCoordinates(parent, x, y);
            final String ssid = this.canvasHandler.getDiagram().getMetadata().getShapeSetId();
            ebc.getElementCommands((org.kie.workbench.common.stunner.core.graph.Element)node, parent, ebc.getParentAssignment(parent, nodeDef), childCoordinates.getX(), childCoordinates.getY(), new AbstractElementBuilderControl.CommandsCallback(){

                @Override
                public void onComplete(String uuid, List<Command<AbstractCanvasHandler, CanvasViolation>> commands) {
                    CommandResult results;
                    CompositeCommand.Builder commandBuilder = new CompositeCommand.Builder().addCommands(commands);
                    if (inEdge != null) {
                        Object edgeDef = ((ViewConnector)inEdge.getContent()).getDefinition();
                        String edgeId = NodeBuilderControlImpl.this.clientDefinitionManager.adapters().forDefinition().getId(edgeDef);
                        commandBuilder.addCommand((Command)NodeBuilderControlImpl.this.commandFactory.addConnector(inEdge.getSourceNode(), inEdge, sourceConnection, ssid));
                        commandBuilder.addCommand((Command)NodeBuilderControlImpl.this.commandFactory.setTargetNode(node, inEdge, targetConnection));
                    }
                    if (!CommandUtils.isError((CommandResult)(results = NodeBuilderControlImpl.this.elementBuilderControl.getCommandManager().execute((Object)NodeBuilderControlImpl.this.canvasHandler, (Command)commandBuilder.build())))) {
                        NodeBuilderControlImpl.this.updateConnectorShape(inEdge, node, sourceConnection, targetConnection);
                    }
                    buildCallback.onSuccess(uuid);
                }

                @Override
                public void onError(ClientRuntimeError error) {
                    buildCallback.onError(error);
                }
            });
        }
    }

    protected void updateConnectorShape(Edge<? extends ViewConnector<?>, Node> inEdge, Node targetNode, Connection sourceConnection, Connection targetConnection) {
        ViewConnector connectorContent = (ViewConnector)inEdge.getContent();
        this.canvasHandler.applyElementMutation((org.kie.workbench.common.stunner.core.graph.Element)inEdge, MutationContext.STATIC);
        EdgeShape edgeShape = (EdgeShape)this.canvasHandler.getCanvas().getShape(inEdge.getUUID());
        Node source = inEdge.getSourceNode();
        if (null != source && null != targetNode) {
            Shape sShape = this.canvasHandler.getCanvas().getShape(source.getUUID());
            Shape tShape = this.canvasHandler.getCanvas().getShape(targetNode.getUUID());
            connectorContent.setSourceConnection(sourceConnection);
            connectorContent.setTargetConnection(targetConnection);
            edgeShape.applyConnections(inEdge, sShape.getShapeView(), tShape.getShapeView(), MutationContext.STATIC);
        }
    }

    protected ElementBuilderControlImpl getElementBuilderControl() {
        return (ElementBuilderControlImpl)this.elementBuilderControl;
    }
}

