/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.canvas.controls.clipboard;

import java.util.stream.StreamSupport;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.kie.workbench.common.stunner.core.client.annotation.DiagramEditor;
import org.kie.workbench.common.stunner.core.client.canvas.controls.clipboard.ClipboardControl;
import org.uberfire.client.mvp.ActivityBeansCache;
import org.uberfire.client.workbench.events.AbstractPlaceEvent;
import org.uberfire.client.workbench.events.PlaceLostFocusEvent;

@ApplicationScoped
public class ClipboardControlCleaner {
    private final ActivityBeansCache activityBeansCache;
    private final ManagedInstance<ClipboardControl> clipboardControls;

    @Inject
    public ClipboardControlCleaner(ManagedInstance<ClipboardControl> clipboardControls, ActivityBeansCache activityBeansCache) {
        this.activityBeansCache = activityBeansCache;
        this.clipboardControls = clipboardControls;
    }

    public void onPlaceGainFocusEvent(@Observes PlaceLostFocusEvent event) {
        if (this.verifyIsDiagramEditor((AbstractPlaceEvent)event)) {
            StreamSupport.stream(this.clipboardControls.spliterator(), false).forEach(ClipboardControl::clear);
        }
    }

    private boolean verifyIsDiagramEditor(AbstractPlaceEvent event) {
        return this.activityBeansCache.getActivity(event.getPlace().getIdentifier()).getQualifiers().stream().anyMatch(a -> a instanceof DiagramEditor);
    }
}

