/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.canvas.util;

import com.google.gwt.user.client.Timer;
import java.util.Optional;
import javax.annotation.PreDestroy;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.kie.workbench.common.stunner.core.api.DefinitionManager;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.CanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.event.selection.CanvasSelectionEvent;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.Graph;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.Bounds;
import org.kie.workbench.common.stunner.core.graph.content.view.Point2D;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.kie.workbench.common.stunner.core.graph.content.view.ViewConnector;
import org.kie.workbench.common.stunner.core.graph.processing.index.bounds.GraphBoundsIndexer;
import org.kie.workbench.common.stunner.core.graph.util.GraphUtils;
import org.kie.workbench.common.stunner.core.rule.RuleEvaluationContext;
import org.kie.workbench.common.stunner.core.rule.RuleManager;
import org.kie.workbench.common.stunner.core.rule.RuleSet;
import org.kie.workbench.common.stunner.core.rule.RuleViolations;
import org.kie.workbench.common.stunner.core.rule.context.NodeContainmentContext;
import org.kie.workbench.common.stunner.core.rule.context.impl.RuleContextBuilder;
import org.kie.workbench.common.stunner.core.validation.Violation;

@Dependent
public class CanvasLayoutUtils {
    private static final int PADDING_X = 40;
    private static final int PADDING_Y = 40;
    private static final int CANVAS_BOTTOM_MARGIN = 15;
    @Inject
    private GraphBoundsIndexer graphBoundsIndexer;
    @Inject
    private RuleManager ruleManager;
    @Inject
    private DefinitionManager definitionManager;

    public CanvasLayoutUtils() {
    }

    CanvasLayoutUtils(GraphBoundsIndexer graphBoundsIndexer, RuleManager ruleManager, DefinitionManager definitionManager) {
        this.graphBoundsIndexer = graphBoundsIndexer;
        this.ruleManager = ruleManager;
        this.definitionManager = definitionManager;
    }

    public static boolean isCanvasRoot(Diagram diagram, Element parent) {
        return null != parent && CanvasLayoutUtils.isCanvasRoot(diagram, parent.getUUID());
    }

    public static boolean isCanvasRoot(Diagram diagram, String pUUID) {
        String canvasRoot = diagram.getMetadata().getCanvasRootUUID();
        return null != canvasRoot && null != pUUID && canvasRoot.equals(pUUID);
    }

    public static int getPaddingX() {
        return 40;
    }

    public static int getPaddingY() {
        return 40;
    }

    @PreDestroy
    public void destroy() {
        this.graphBoundsIndexer.destroy();
    }

    public Point2D getNext(CanvasHandler canvasHandler, Node<View<?>, Edge> root, Node<View<?>, Edge> newNode) {
        double[] rootBounds = this.getBoundCoordinates(root);
        double[] rootSize = GraphUtils.getNodeSize((View)((View)root.getContent()));
        double[] newNodeSize = GraphUtils.getNodeSize((View)((View)newNode.getContent()));
        Point2D[] offset = new Point2D[]{new Point2D(40.0, 0.0)};
        Point2D[] parentOffset = new Point2D[]{new Point2D(0.0, 0.0)};
        double[] maxNodeY = new double[]{0.0};
        if (root.getOutEdges().size() > 0) {
            root.getOutEdges().stream().filter(e -> e.getContent() instanceof ViewConnector).filter(e -> null != e.getTargetNode() && !e.getTargetNode().equals(newNode)).forEach(n -> {
                Node node = n.getTargetNode();
                Point2D nodePos = GraphUtils.getPosition((View)((View)node.getContent()));
                Point2D rootPos = GraphUtils.getPosition((View)((View)root.getContent()));
                if (nodePos.getY() > maxNodeY[0]) {
                    maxNodeY[0] = nodePos.getY();
                    double[] nodeSize = GraphUtils.getNodeSize((View)((View)node.getContent()));
                    offset[0].setY(maxNodeY[0] + nodeSize[1] - rootPos.getY());
                }
            });
            offset[0].setY(offset[0].getY() + parentOffset[0].getY() + 40.0);
        } else {
            offset[0].setY(parentOffset[0].getY() - (newNodeSize[1] - rootSize[1]) / 2.0);
        }
        offset[0].setX(offset[0].getX() + 40.0);
        Point2D offsetCoordinates = new Point2D(offset[0].getX(), offset[0].getY());
        Point2D rootNodeCoordinates = new Point2D(rootBounds[0], rootBounds[1]);
        return this.getNext(canvasHandler, root, rootSize[0], rootSize[1], newNodeSize[0], newNodeSize[1], offsetCoordinates, rootNodeCoordinates);
    }

    public Point2D getNext(CanvasHandler canvasHandler, Node<View<?>, Edge> root, double rootNodeWidth, double rootNodeHeight, double newNodeWidth, double newNodeHeight, Point2D offset, Point2D rootNodeCoordinates) {
        PortablePreconditions.checkNotNull((String)"canvasHandler", (Object)canvasHandler);
        PortablePreconditions.checkNotNull((String)"root", root);
        int canvasHeight = canvasHandler.getCanvas().getHeight();
        int canvasWidth = canvasHandler.getCanvas().getWidth();
        Point2D newPositionUL = this.getNextPositionWithOffset(rootNodeCoordinates, offset);
        this.graphBoundsIndexer.build((Object)canvasHandler.getDiagram().getGraph());
        Element parentNode = GraphUtils.getParent((Node)root.asNode());
        boolean checkParent = false;
        if (parentNode != null && !CanvasLayoutUtils.isCanvasRoot(canvasHandler.getDiagram(), parentNode.getUUID())) {
            checkParent = true;
        }
        Node targetNodeContainer = (Node)this.graphBoundsIndexer.getAt(newPositionUL.getX(), newPositionUL.getY(), newNodeWidth, newNodeHeight, parentNode);
        boolean canContain = false;
        if (targetNodeContainer != null) {
            canContain = this.canContain(canvasHandler, targetNodeContainer, root);
        }
        if (!canContain || this.isOutOfCanvas(newPositionUL, newNodeHeight, canvasHeight) || checkParent) {
            if (checkParent) {
                newPositionUL = this.getNextPositionFromParent(rootNodeCoordinates, offset, parentNode, rootNodeHeight, rootNodeWidth, newNodeWidth);
            }
            while (!this.isCanvasPositionAvailable(this.graphBoundsIndexer, newPositionUL, newNodeWidth, newNodeHeight, parentNode) && !canContain && newPositionUL.getY() < (double)canvasHeight && newPositionUL.getX() < (double)canvasWidth || this.isOutOfCanvas(newPositionUL, newNodeHeight, canvasHeight)) {
                parentNode = GraphUtils.getParent((Node)root.asNode());
                checkParent = false;
                if (parentNode != null && !CanvasLayoutUtils.isCanvasRoot(canvasHandler.getDiagram(), parentNode.getUUID())) {
                    checkParent = true;
                }
                double[] nodeAtPositionSize = this.getNodeSizeAt(this.graphBoundsIndexer, newPositionUL, newNodeWidth, newNodeHeight, parentNode);
                if (checkParent) {
                    Node targetNodeNewPos = (Node)this.graphBoundsIndexer.getAt(newPositionUL.getX(), newPositionUL.getY(), newNodeWidth, newNodeHeight, parentNode);
                    if (parentNode != targetNodeNewPos) {
                        offset.setY(offset.getY() + 40.0);
                    }
                } else if (nodeAtPositionSize == null) {
                    nodeAtPositionSize = new double[]{0.0};
                    offset.setY(offset.getY() + 40.0);
                } else {
                    offset.setY(offset.getY() + nodeAtPositionSize[1] + 40.0);
                }
                newPositionUL = this.getNextPositionWithOffset(rootNodeCoordinates, offset);
                if (this.isOutOfCanvas(newPositionUL, newNodeHeight, canvasHeight)) {
                    rootNodeCoordinates.setY(0.0);
                    offset.setY(40.0);
                    offset.setX(offset.getX() + nodeAtPositionSize[0] + 40.0);
                    newPositionUL = this.getNextPositionWithOffset(rootNodeCoordinates, offset);
                }
                if (checkParent) {
                    newPositionUL = this.getNextPositionFromParent(rootNodeCoordinates, offset, parentNode, rootNodeHeight, rootNodeWidth, newNodeWidth);
                }
                canContain = (targetNodeContainer = (Node)this.graphBoundsIndexer.getAt(newPositionUL.getX(), newPositionUL.getY(), newNodeWidth, newNodeHeight, parentNode)) == null || this.canContain(canvasHandler, targetNodeContainer, root);
            }
        } else {
            newPositionUL = checkParent ? this.getNextPositionFromParent(rootNodeCoordinates, offset, parentNode, rootNodeHeight, rootNodeWidth, newNodeWidth) : this.getNextPositionWithOffset(rootNodeCoordinates, offset);
        }
        return newPositionUL;
    }

    private Point2D getNextPositionFromParent(Point2D rootNodeCoordinates, Point2D offset, Element parentNode, double rootNodeHeight, double rootNodeWidth, double nodeWidth) {
        double parentPositionToCheckX;
        Point2D nextPosition = this.getNextPositionWithOffset(rootNodeCoordinates, offset);
        double[] parentNodeSize = GraphUtils.getNodeSize((View)((View)parentNode.getContent()));
        Point2D parentPosition = GraphUtils.getPosition((View)((View)parentNode.getContent()));
        double newPositionToCheckX = rootNodeCoordinates.getX() + rootNodeWidth + 40.0 + nodeWidth;
        if (newPositionToCheckX > (parentPositionToCheckX = parentNodeSize[0] + parentPosition.getX())) {
            nextPosition.setX(parentPosition.getX() + 40.0);
            nextPosition.setY(rootNodeCoordinates.getY() + rootNodeHeight + 40.0 + offset.getY());
        }
        return nextPosition;
    }

    private boolean canContain(CanvasHandler canvasHandler, Node container, Node candidate) {
        boolean canContain = true;
        NodeContainmentContext containmentContext = RuleContextBuilder.GraphContexts.containment((Graph)canvasHandler.getDiagram().getGraph(), (Element)container, (Node)candidate);
        String definitionSetId = canvasHandler.getDiagram().getMetadata().getDefinitionSetId();
        Object definitionSet = this.definitionManager.definitionSets().getDefinitionSetById(definitionSetId);
        RuleSet ruleSet = this.definitionManager.adapters().forRules().getRuleSet(definitionSet);
        RuleViolations violations = this.ruleManager.evaluate(ruleSet, (RuleEvaluationContext)containmentContext);
        if (violations.violations(Violation.Type.ERROR).iterator().hasNext()) {
            canContain = false;
        }
        return canContain;
    }

    private boolean isOutOfCanvas(Point2D newPositionUL, double newNodeHeight, double canvasHeight) {
        return newPositionUL.getY() + newNodeHeight > canvasHeight - 15.0;
    }

    private Point2D getNextPositionWithOffset(Point2D nextPosition, Point2D offset) {
        return new Point2D(nextPosition.getX() + offset.getX(), nextPosition.getY() + offset.getY());
    }

    private double[] getNodeSizeAt(GraphBoundsIndexer graphBoundsIndexer, Point2D position, double w, double h, Element parentNode) {
        Node targetNode = (Node)graphBoundsIndexer.getAt(position.getX(), position.getY(), w, h, parentNode);
        if (targetNode != null) {
            return GraphUtils.getNodeSize((View)((View)targetNode.getContent()));
        }
        return null;
    }

    private boolean isCanvasPositionAvailable(GraphBoundsIndexer graphBoundsIndexer, Point2D positionUL, double width, double height, Element parentNode) {
        Node targetNode = (Node)graphBoundsIndexer.getAt(positionUL.getX(), positionUL.getY(), width, height, parentNode);
        return targetNode == null;
    }

    private double[] getBoundCoordinates(Node<View<?>, Edge> node) {
        if (GraphUtils.isDockedNode(node)) {
            Node parent = (Node)GraphUtils.getDockParent(node).get();
            Point2D parentPosition = GraphUtils.getPosition((View)((View)parent.getContent()));
            return this.getBoundCoordinates((View)node.getContent(), Optional.ofNullable(parentPosition));
        }
        return this.getBoundCoordinates((View)node.getContent(), Optional.empty());
    }

    private double[] getBoundCoordinates(View view, Optional<Point2D> parentPosition) {
        Point2D relativePositionTo = parentPosition.orElse(new Point2D(0.0, 0.0));
        Bounds bounds = view.getBounds();
        Bounds.Bound ulBound = bounds.getUpperLeft();
        Bounds.Bound lrBound = bounds.getLowerRight();
        double lrX = lrBound.getX();
        double lrY = ulBound.getY();
        return new double[]{lrX + relativePositionTo.getX(), lrY + relativePositionTo.getY()};
    }

    public static Element<?> getElement(AbstractCanvasHandler canvasHandler, String uuid) {
        return canvasHandler.getGraphIndex().get(uuid);
    }

    public static void fireElementSelectedEvent(Event<CanvasSelectionEvent> selectionEvent, final CanvasHandler canvasHandler, String uuid) {
        canvasHandler.getCanvas().getLayer().disableHandlers();
        selectionEvent.fire((Object)new CanvasSelectionEvent(canvasHandler, uuid));
        Timer t = new Timer(){

            public void run() {
                canvasHandler.getCanvas().getLayer().enableHandlers();
            }
        };
        t.schedule(500);
    }
}

