/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.command;

import java.util.Stack;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.kie.workbench.common.stunner.core.client.api.SessionManager;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.event.mouse.CanvasMouseDownEvent;
import org.kie.workbench.common.stunner.core.client.canvas.event.mouse.CanvasMouseUpEvent;
import org.kie.workbench.common.stunner.core.client.command.AbstractSessionCommandManager;
import org.kie.workbench.common.stunner.core.client.command.CanvasViolation;
import org.kie.workbench.common.stunner.core.client.command.Request;
import org.kie.workbench.common.stunner.core.client.session.event.SessionDestroyedEvent;
import org.kie.workbench.common.stunner.core.client.session.event.SessionOpenedEvent;
import org.kie.workbench.common.stunner.core.command.Command;
import org.kie.workbench.common.stunner.core.command.CommandListener;
import org.kie.workbench.common.stunner.core.command.CommandResult;
import org.kie.workbench.common.stunner.core.command.impl.CommandRegistryListener;
import org.kie.workbench.common.stunner.core.command.impl.CompositeCommand;
import org.kie.workbench.common.stunner.core.command.util.CommandUtils;
import org.kie.workbench.common.stunner.core.registry.command.CommandRegistry;

@ApplicationScoped
@Request
public class RequestCommandManager
extends AbstractSessionCommandManager {
    private static Logger LOGGER = Logger.getLogger(RequestCommandManager.class.getName());
    private final SessionManager sessionManager;
    private Stack<Command<AbstractCanvasHandler, CanvasViolation>> commands;
    private boolean roolback;
    private CommandListener<AbstractCanvasHandler, CanvasViolation> registryListener = new CommandRegistryListener<AbstractCanvasHandler, CanvasViolation>(){

        public void onAllow(AbstractCanvasHandler context, Command<AbstractCanvasHandler, CanvasViolation> command, CommandResult<CanvasViolation> result) {
            RequestCommandManager.this.postAllow(context, command, result);
        }

        public void onExecute(AbstractCanvasHandler context, Command<AbstractCanvasHandler, CanvasViolation> command, CommandResult<CanvasViolation> result) {
            LOGGER.log(Level.FINEST, "Adding command [" + command + "] into current request command builder.");
            if (CommandUtils.isError(result)) {
                LOGGER.log(Level.FINEST, "Command failed - rollback");
                RequestCommandManager.this.roolback = true;
            } else if (RequestCommandManager.this.commands != null) {
                RequestCommandManager.this.commands.push(command);
            } else {
                this.getRegistry().register(command);
            }
            RequestCommandManager.this.postExecute(context, command, result);
        }

        public void onUndo(AbstractCanvasHandler context, Command<AbstractCanvasHandler, CanvasViolation> command, CommandResult<CanvasViolation> result) {
            super.onUndo((Object)context, command, result);
            RequestCommandManager.this.postUndo(context, command, result);
        }

        protected CommandRegistry<Command<AbstractCanvasHandler, CanvasViolation>> getRegistry() {
            return RequestCommandManager.this.getRegistry();
        }
    };

    protected RequestCommandManager() {
        this(null);
    }

    @Inject
    public RequestCommandManager(SessionManager sessionManager) {
        this.sessionManager = sessionManager;
        this.roolback = false;
    }

    @Override
    protected SessionManager getClientSessionManager() {
        return this.sessionManager;
    }

    @Override
    protected CommandListener<AbstractCanvasHandler, CanvasViolation> getRegistryListener() {
        return this.registryListener;
    }

    void onCanvasMouseDownEvent(@Observes CanvasMouseDownEvent mouseDownEvent) {
        PortablePreconditions.checkNotNull((String)"mouseDownEvent", (Object)mouseDownEvent);
        this.start();
    }

    void onCanvasMouseUpEvent(@Observes CanvasMouseUpEvent mouseUpEvent) {
        PortablePreconditions.checkNotNull((String)"mouseUpEvent", (Object)mouseUpEvent);
        this.complete();
    }

    void onCanvasSessionOpened(@Observes SessionOpenedEvent sessionOpenedEvent) {
        PortablePreconditions.checkNotNull((String)"sessionOpenedEvent", (Object)sessionOpenedEvent);
        if (this.isRequestStarted()) {
            LOGGER.log(Level.WARNING, "New session opened but the request has not been completed. Unexpected behaviors can occur.");
            this.clear();
        }
    }

    void onCanvasSessionDestroyed(@Observes SessionDestroyedEvent sessionDestroyedEvent) {
        PortablePreconditions.checkNotNull((String)"sessionDestroyedEvent", (Object)sessionDestroyedEvent);
        if (this.isRequestStarted()) {
            LOGGER.log(Level.WARNING, "Current client request has not been completed yet.");
        }
    }

    private void start() {
        if (this.isRequestStarted()) {
            LOGGER.log(Level.WARNING, "Current client request has not been completed yet.A new client request cannot be started!");
            this.clear();
        }
        LOGGER.log(Level.FINEST, "New client request started.");
        this.commands = new Stack();
        this.roolback = false;
    }

    private void complete() {
        if (this.isRequestStarted()) {
            boolean hasCommands;
            boolean bl = hasCommands = !this.commands.isEmpty();
            if (hasCommands && this.roolback) {
                LOGGER.log(Level.FINEST, "Performing rollback for commands in current requrest.");
                AbstractCanvasHandler canvasHandler = (AbstractCanvasHandler)this.getCurrentSession().getCanvasHandler();
                this.commands.forEach((Consumer<Command<AbstractCanvasHandler, CanvasViolation>>)((Consumer<Command>)c -> c.undo((Object)canvasHandler)));
            } else if (hasCommands) {
                LOGGER.log(Level.FINEST, "Adding commands for current request into registry [size=" + this.commands.size() + "]");
                this.getRegistry().register((Command)new CompositeCommand.Builder().forward().addCommands(this.commands.stream().collect(Collectors.toList())).build());
            }
            LOGGER.log(Level.FINEST, "Current client request completed.");
        } else {
            LOGGER.log(Level.WARNING, "Current client request has not been started.");
        }
        this.clear();
    }

    private boolean isRequestStarted() {
        return null != this.commands;
    }

    private void clear() {
        this.setDelegateListener(null);
        if (this.commands != null) {
            this.commands.clear();
            this.commands = null;
        }
        this.roolback = false;
    }
}

