/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.components.views;

import java.util.function.Function;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.kie.workbench.common.stunner.core.api.DefinitionManager;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.Transform;
import org.kie.workbench.common.stunner.core.client.components.views.CanvasTooltip;
import org.kie.workbench.common.stunner.core.graph.content.view.Point2D;
import org.kie.workbench.common.stunner.core.registry.impl.DefinitionsCacheRegistry;

@Dependent
public class CanvasDefinitionTooltip
implements CanvasTooltip<DefinitionIdContent> {
    private final CanvasTooltip<String> textTooltip;
    private final Function<String, String> titleProvider;
    private String prefix;

    @Inject
    public CanvasDefinitionTooltip(DefinitionManager definitionManager, DefinitionsCacheRegistry registry, CanvasTooltip<String> textTooltip) {
        this(textTooltip, defId -> CanvasDefinitionTooltip.getDefinitionTitle(definitionManager, registry, defId));
    }

    CanvasDefinitionTooltip(CanvasTooltip<String> textTooltip, Function<String, String> titleProvider) {
        this.textTooltip = textTooltip;
        this.titleProvider = titleProvider;
        this.prefix = "";
    }

    public CanvasDefinitionTooltip setPrefix(String value) {
        this.prefix = value;
        return this;
    }

    public CanvasDefinitionTooltip configure(AbstractCanvasHandler canvasHandler) {
        this.setTransform(canvasHandler.getCanvas().getLayer().getTransform());
        this.setCanvasLocation(new Point2D(canvasHandler.getAbstractCanvas().getView().getAbsoluteX(), canvasHandler.getAbstractCanvas().getView().getAbsoluteY()));
        return this;
    }

    public void setCanvasLocation(Point2D location) {
        this.textTooltip.setCanvasLocation(location);
    }

    public void setTransform(Transform transform) {
        this.textTooltip.setTransform(transform);
    }

    public void show(DefinitionIdContent content, Point2D location) {
        this.show(content.id, location);
    }

    public void show(String definitionId, Point2D location) {
        String title = this.titleProvider.apply(definitionId);
        this.textTooltip.show((Object)(this.prefix + title), location);
    }

    public void hide() {
        this.textTooltip.hide();
    }

    public void destroy() {
        this.textTooltip.destroy();
    }

    private static String getDefinitionTitle(DefinitionManager definitionManager, DefinitionsCacheRegistry registry, String id) {
        return definitionManager.adapters().forDefinition().getTitle(registry.getDefinitionById(id));
    }

    public static class DefinitionIdContent {
        private final String id;

        public DefinitionIdContent(String id) {
            this.id = id;
        }
    }
}

