/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.preferences;

import java.lang.annotation.Annotation;
import javax.annotation.PreDestroy;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Any;
import javax.inject.Inject;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.kie.workbench.common.stunner.core.client.preferences.StunnerPreferencesRegistryHolder;
import org.kie.workbench.common.stunner.core.client.session.impl.InstanceUtils;
import org.kie.workbench.common.stunner.core.preferences.StunnerPreferences;
import org.kie.workbench.common.stunner.core.util.DefinitionUtils;
import org.uberfire.mvp.ParameterizedCommand;

@ApplicationScoped
public class StunnerPreferencesRegistryLoader {
    private final DefinitionUtils definitionUtils;
    private final ManagedInstance<StunnerPreferencesRegistryHolder> preferencesHolders;
    private final StunnerPreferences preferences;

    @Inject
    public StunnerPreferencesRegistryLoader(DefinitionUtils definitionUtils, @Any ManagedInstance<StunnerPreferencesRegistryHolder> preferencesHolders, StunnerPreferences preferences) {
        this.definitionUtils = definitionUtils;
        this.preferencesHolders = preferencesHolders;
        this.preferences = preferences;
    }

    public void load(String definitionSetId, ParameterizedCommand<StunnerPreferences> loadCompleteCallback, ParameterizedCommand<Throwable> errorCallback) {
        Annotation qualifier = this.definitionUtils.getQualifier(definitionSetId);
        StunnerPreferencesRegistryHolder holder = InstanceUtils.lookup(this.preferencesHolders, qualifier);
        this.preferences.load(prefs -> {
            holder.set((StunnerPreferences)prefs);
            loadCompleteCallback.execute(prefs);
        }, errorCallback);
    }

    @PreDestroy
    public void destroy() {
        this.preferencesHolders.destroyAll();
    }
}

