/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.session.impl;

import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.controls.AbstractCanvasHandlerRegistrationControl;
import org.kie.workbench.common.stunner.core.client.canvas.controls.CanvasControl;
import org.kie.workbench.common.stunner.core.client.canvas.controls.CanvasRegistrationControl;
import org.kie.workbench.common.stunner.core.client.canvas.listener.CanvasElementListener;
import org.kie.workbench.common.stunner.core.graph.Element;

public class DefaultCanvasElementListener
implements CanvasElementListener {
    private final Iterable<CanvasControl<AbstractCanvasHandler>> canvasControls;

    public DefaultCanvasElementListener(Iterable<CanvasControl<AbstractCanvasHandler>> canvasControls) {
        this.canvasControls = canvasControls;
    }

    public void update(Element item) {
        this.onElementRegistration(item, false, true);
    }

    public void register(Element item) {
        this.onRegisterElement(item);
    }

    public void deregister(Element item) {
        this.onDeregisterElement(item);
    }

    public void clear() {
        this.onClear();
    }

    private void onRegisterElement(Element element) {
        this.onElementRegistration(element, true, false);
    }

    private void onDeregisterElement(Element element) {
        this.onElementRegistration(element, false, false);
    }

    private void onElementRegistration(Element element, boolean add, boolean update) {
        if (update) {
            this.canvasControls.forEach(c -> this.fireRegistrationUpdateListeners((CanvasControl<AbstractCanvasHandler>)c, element));
        } else {
            this.canvasControls.forEach(c -> this.fireRegistrationListeners((CanvasControl<AbstractCanvasHandler>)c, element, add));
        }
    }

    private void onClear() {
        this.canvasControls.forEach(this::fireRegistrationClearListeners);
    }

    private void fireRegistrationListeners(CanvasControl<AbstractCanvasHandler> control, Element element, boolean add) {
        if (null != element && control instanceof CanvasRegistrationControl) {
            CanvasRegistrationControl registrationControl = (CanvasRegistrationControl)control;
            if (add) {
                registrationControl.register((Object)element);
            } else {
                registrationControl.deregister((Object)element);
            }
        }
    }

    private void fireRegistrationUpdateListeners(CanvasControl<AbstractCanvasHandler> control, Element element) {
        if (null != element && control instanceof AbstractCanvasHandlerRegistrationControl) {
            AbstractCanvasHandlerRegistrationControl registrationControl = (AbstractCanvasHandlerRegistrationControl)control;
            registrationControl.update(element);
        }
    }

    private void fireRegistrationClearListeners(CanvasControl<AbstractCanvasHandler> control) {
        if (control instanceof CanvasRegistrationControl) {
            CanvasRegistrationControl registrationControl = (CanvasRegistrationControl)control;
            registrationControl.clear();
        }
    }
}

