/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.shape.impl;

import org.kie.workbench.common.stunner.core.client.shape.ShapeState;
import org.kie.workbench.common.stunner.core.client.shape.impl.ShapeStateAttributeHandler;

public class ShapeStateAttributesFactory {
    static final String COLOR_SELECTED = "#0000FF";
    static final String COLOR_HIGHLIGHT = "#3366CC";
    static final String COLOR_INVALID = "#FF0000";

    public static ShapeStateAttributeHandler.ShapeStateAttributes buildStrokeAttributes(ShapeState state) {
        String COLOR = ShapeStateAttributesFactory.getAttributeColorByState(state);
        if (null == COLOR) {
            return ShapeStateAttributesFactory.buildAttributes();
        }
        return ShapeStateAttributesFactory.buildAttributes().set(ShapeStateAttributeHandler.ShapeStateAttribute.STROKE_ALPHA, 1.0).set(ShapeStateAttributeHandler.ShapeStateAttribute.STROKE_COLOR, COLOR);
    }

    public static ShapeStateAttributeHandler.ShapeStateAttributes buildFillAttributes(ShapeState state) {
        String COLOR = ShapeStateAttributesFactory.getAttributeColorByState(state);
        if (null == COLOR) {
            return ShapeStateAttributesFactory.buildAttributes();
        }
        return ShapeStateAttributesFactory.buildAttributes().set(ShapeStateAttributeHandler.ShapeStateAttribute.FILL_COLOR, COLOR).set(ShapeStateAttributeHandler.ShapeStateAttribute.FILL_ALPHA, 1.0);
    }

    private static String getAttributeColorByState(ShapeState state) {
        switch (state) {
            case SELECTED: {
                return COLOR_SELECTED;
            }
            case HIGHLIGHT: {
                return COLOR_HIGHLIGHT;
            }
            case INVALID: {
                return COLOR_INVALID;
            }
        }
        return null;
    }

    private static ShapeStateAttributeHandler.ShapeStateAttributes buildAttributes() {
        return new ShapeStateAttributeHandler.ShapeStateAttributes();
    }
}

