/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.shape.view.handler;

import java.util.function.Function;
import org.kie.workbench.common.stunner.core.client.shape.view.HasTitle;
import org.kie.workbench.common.stunner.core.client.shape.view.ShapeView;
import org.kie.workbench.common.stunner.core.client.shape.view.ShapeViewHandler;

public class FontHandler<W, V extends ShapeView>
implements ShapeViewHandler<W, V> {
    private final Function<W, Double> alphaProvider;
    private final Function<W, String> fontFamilyProvider;
    private final Function<W, String> fontColorProvider;
    private final Function<W, Double> fontSizeProvider;
    private final Function<W, String> strokeColorProvider;
    private final Function<W, Double> strokeSizeProvider;
    private final Function<W, HasTitle.Position> positionProvider;
    private final Function<W, Double> rotationProvider;

    FontHandler(Function<W, Double> alphaProvider, Function<W, String> fontFamilyProvider, Function<W, String> fontColorProvider, Function<W, Double> fontSizeProvider, Function<W, String> strokeColorProvider, Function<W, Double> strokeSizeProvider, Function<W, HasTitle.Position> positionProvider, Function<W, Double> rotationProvider) {
        this.alphaProvider = alphaProvider;
        this.fontFamilyProvider = fontFamilyProvider;
        this.fontColorProvider = fontColorProvider;
        this.fontSizeProvider = fontSizeProvider;
        this.strokeColorProvider = strokeColorProvider;
        this.strokeSizeProvider = strokeSizeProvider;
        this.positionProvider = positionProvider;
        this.rotationProvider = rotationProvider;
    }

    public void handle(W element, V view) {
        if (view instanceof HasTitle) {
            HasTitle hasTitle = (HasTitle)view;
            Double alpha = this.alphaProvider.apply(element);
            String fontFamily = this.fontFamilyProvider.apply(element);
            String fontColor = this.fontColorProvider.apply(element);
            Double fontSize = this.fontSizeProvider.apply(element);
            String strokeColor = this.strokeColorProvider.apply(element);
            Double strokeSize = this.strokeSizeProvider.apply(element);
            HasTitle.Position position = this.positionProvider.apply(element);
            Double rotation = this.rotationProvider.apply(element);
            if (fontFamily != null && fontFamily.trim().length() > 0) {
                hasTitle.setTitleFontFamily(fontFamily);
            }
            if (fontColor != null && fontColor.trim().length() > 0) {
                hasTitle.setTitleFontColor(fontColor);
            }
            if (strokeColor != null && strokeColor.trim().length() > 0) {
                hasTitle.setTitleStrokeColor(strokeColor);
            }
            if (fontSize != null && fontSize > 0.0) {
                hasTitle.setTitleFontSize(fontSize.doubleValue());
            }
            if (strokeSize != null && strokeSize > 0.0) {
                hasTitle.setTitleStrokeWidth(strokeSize.doubleValue());
            }
            if (null != alpha) {
                hasTitle.setTitleAlpha(alpha.doubleValue());
            }
            if (null != position) {
                hasTitle.setTitlePosition(position);
            }
            if (null != rotation) {
                hasTitle.setTitleRotation(rotation.doubleValue());
            }
        }
    }

    public static class Builder<W, V extends ShapeView> {
        private Function<W, Double> alphaProvider = value -> null;
        private Function<W, String> fontFamilyProvider = value -> null;
        private Function<W, String> fontColorProvider = value -> null;
        private Function<W, Double> fontSizeProvider = value -> null;
        private Function<W, String> strokeColorProvider = value -> null;
        private Function<W, Double> strokeSizeProvider = value -> null;
        private Function<W, HasTitle.Position> positionProvider = value -> null;
        private Function<W, Double> rotationProvider = value -> null;

        public Builder<W, V> alpha(Function<W, Double> alphaProvider) {
            this.alphaProvider = alphaProvider;
            return this;
        }

        public Builder<W, V> fontFamily(Function<W, String> provider) {
            this.fontFamilyProvider = provider;
            return this;
        }

        public Builder<W, V> fontColor(Function<W, String> provider) {
            this.fontColorProvider = provider;
            return this;
        }

        public Builder<W, V> fontSize(Function<W, Double> provider) {
            this.fontSizeProvider = provider;
            return this;
        }

        public Builder<W, V> strokeColor(Function<W, String> provider) {
            this.strokeColorProvider = provider;
            return this;
        }

        public Builder<W, V> strokeSize(Function<W, Double> provider) {
            this.strokeSizeProvider = provider;
            return this;
        }

        public Builder<W, V> positon(Function<W, HasTitle.Position> provider) {
            this.positionProvider = provider;
            return this;
        }

        public Builder<W, V> rotation(Function<W, Double> provider) {
            this.rotationProvider = provider;
            return this;
        }

        public FontHandler<W, V> build() {
            return new FontHandler(this.alphaProvider, this.fontFamilyProvider, this.fontColorProvider, this.fontSizeProvider, this.strokeColorProvider, this.strokeSizeProvider, this.positionProvider, this.rotationProvider);
        }
    }
}

