/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.validation.canvas;

import java.util.Collection;
import java.util.function.Consumer;
import java.util.stream.Stream;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.shape.Shape;
import org.kie.workbench.common.stunner.core.client.shape.ShapeState;
import org.kie.workbench.common.stunner.core.client.validation.canvas.CanvasValidationFailEvent;
import org.kie.workbench.common.stunner.core.client.validation.canvas.CanvasValidationSuccessEvent;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.rule.RuleViolation;
import org.kie.workbench.common.stunner.core.validation.DiagramElementViolation;
import org.kie.workbench.common.stunner.core.validation.DiagramValidator;
import org.kie.workbench.common.stunner.core.validation.Violation;

@Dependent
public class CanvasDiagramValidator<H extends AbstractCanvasHandler> {
    private final DiagramValidator<Diagram, RuleViolation> diagramValidator;
    private final Event<CanvasValidationSuccessEvent> validationSuccessEvent;
    private final Event<CanvasValidationFailEvent> validationFailEvent;

    protected CanvasDiagramValidator() {
        this(null, null, null);
    }

    @Inject
    public CanvasDiagramValidator(DiagramValidator<Diagram, RuleViolation> diagramValidator, Event<CanvasValidationSuccessEvent> validationSuccessEvent, Event<CanvasValidationFailEvent> validationFailEvent) {
        this.diagramValidator = diagramValidator;
        this.validationSuccessEvent = validationSuccessEvent;
        this.validationFailEvent = validationFailEvent;
    }

    public void validate(H canvasHandler, Consumer<Collection<DiagramElementViolation<RuleViolation>>> callback) {
        this.diagramValidator.validate((Object)canvasHandler.getDiagram(), violations -> {
            this.checkViolations(canvasHandler, (Collection<DiagramElementViolation<RuleViolation>>)violations);
            callback.accept((Collection<DiagramElementViolation<RuleViolation>>)violations);
        });
    }

    private void checkViolations(H canvasHandler, Collection<DiagramElementViolation<RuleViolation>> elementViolations) {
        String uuid = ((AbstractCanvasHandler)canvasHandler).getUuid();
        Diagram diagram = canvasHandler.getDiagram();
        String name = diagram.getName();
        String title = diagram.getMetadata().getTitle();
        boolean[] valid = new boolean[]{true};
        elementViolations.forEach(v -> {
            if (this.checkViolation(canvasHandler, (DiagramElementViolation<RuleViolation>)v)) {
                valid[0] = false;
            }
        });
        if (valid[0]) {
            this.validationSuccessEvent.fire((Object)new CanvasValidationSuccessEvent(uuid, name, title));
        } else {
            this.validationFailEvent.fire((Object)new CanvasValidationFailEvent(uuid, name, title, elementViolations));
        }
    }

    private boolean checkViolation(H canvasHandler, DiagramElementViolation<RuleViolation> elementViolation) {
        return Stream.concat(elementViolation.getGraphViolations().stream(), elementViolation.getDomainViolations().stream()).filter(v -> v instanceof RuleViolation).anyMatch(v -> this.applyViolation(canvasHandler, (RuleViolation)v));
    }

    private boolean applyViolation(H canvasHandler, RuleViolation violation) {
        if (this.hasViolations(violation)) {
            Shape shape = this.getShape(canvasHandler, violation.getUUID());
            if (null != shape) {
                shape.applyState(ShapeState.INVALID);
            }
            return true;
        }
        return false;
    }

    private Shape getShape(H canvasHandler, String uuid) {
        return canvasHandler.getCanvas().getShape(uuid);
    }

    private boolean hasViolations(RuleViolation violation) {
        return Violation.Type.ERROR.equals((Object)violation.getViolationType()) || Violation.Type.WARNING.equals((Object)violation.getViolationType());
    }
}

