/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.canvas.command;

import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.command.AbstractCanvasCommand;
import org.kie.workbench.common.stunner.core.client.canvas.command.AddCanvasControlPointCommand;
import org.kie.workbench.common.stunner.core.client.canvas.command.DeleteCanvasConnectorCommand;
import org.kie.workbench.common.stunner.core.client.command.CanvasViolation;
import org.kie.workbench.common.stunner.core.client.shape.MutationContext;
import org.kie.workbench.common.stunner.core.client.util.ShapeUtils;
import org.kie.workbench.common.stunner.core.command.CommandResult;
import org.kie.workbench.common.stunner.core.command.util.CommandUtils;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.view.ControlPoint;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.kie.workbench.common.stunner.core.graph.content.view.ViewConnector;

public class AddCanvasConnectorCommand
extends AbstractCanvasCommand {
    private final Edge candidate;
    private final String shapeSetId;

    public AddCanvasConnectorCommand(Edge candidate, String shapeSetId) {
        this.candidate = candidate;
        this.shapeSetId = shapeSetId;
    }

    public CommandResult<CanvasViolation> execute(AbstractCanvasHandler context) {
        context.register(this.shapeSetId, (Element<View<?>>)this.candidate);
        context.applyElementMutation((Element)this.candidate, MutationContext.STATIC);
        if (this.candidate.getContent() instanceof ViewConnector) {
            ControlPoint[] controlPoints = (ControlPoint[])((ViewConnector)this.candidate.getContent()).getControlPoints().stream().toArray(ControlPoint[]::new);
            CommandResult<CanvasViolation> addControlPointsResult = new AddCanvasControlPointCommand(this.candidate, controlPoints).execute(context);
            ShapeUtils.hideControlPoints(this.candidate, context);
            if (CommandUtils.isError(addControlPointsResult)) {
                return addControlPointsResult;
            }
        }
        ShapeUtils.updateEdgeConnections(this.candidate, context);
        ShapeUtils.applyConnections(this.candidate, context, MutationContext.STATIC);
        Node source = this.candidate.getSourceNode();
        if (null != source) {
            context.notifyCanvasElementUpdated((Element)source);
        }
        return this.buildResult();
    }

    public CommandResult<CanvasViolation> undo(AbstractCanvasHandler context) {
        return new DeleteCanvasConnectorCommand(this.candidate).execute(context);
    }

    public Edge getCandidate() {
        return this.candidate;
    }

    public String getShapeSetId() {
        return this.shapeSetId;
    }

    public String toString() {
        return this.getClass().getName() + " [candidate=" + this.getUUID((Element<?>)this.candidate) + ", shapeSet=" + this.getShapeSetId() + "]";
    }
}

