/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.canvas.command;

import java.util.ArrayList;
import java.util.List;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.command.AbstractCanvasCommand;
import org.kie.workbench.common.stunner.core.client.canvas.command.AddCanvasChildNodeCommand;
import org.kie.workbench.common.stunner.core.client.canvas.command.AddCanvasConnectorCommand;
import org.kie.workbench.common.stunner.core.client.canvas.command.CanvasDockNodeCommand;
import org.kie.workbench.common.stunner.core.client.command.CanvasViolation;
import org.kie.workbench.common.stunner.core.command.Command;
import org.kie.workbench.common.stunner.core.command.CommandResult;
import org.kie.workbench.common.stunner.core.command.impl.CompositeCommand;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Graph;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.relationship.Child;
import org.kie.workbench.common.stunner.core.graph.content.relationship.Dock;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.kie.workbench.common.stunner.core.graph.content.view.ViewConnector;
import org.kie.workbench.common.stunner.core.graph.processing.traverse.content.AbstractChildrenTraverseCallback;
import org.kie.workbench.common.stunner.core.graph.processing.traverse.content.ChildrenTraverseProcessor;
import org.kie.workbench.common.stunner.core.graph.util.GraphUtils;

public class CloneCanvasNodeCommand
extends AbstractCanvasCommand {
    private transient CompositeCommand<AbstractCanvasHandler, CanvasViolation> commands;
    private transient ManagedInstance<ChildrenTraverseProcessor> childrenTraverseProcessor;
    private final Node parent;
    private final Node candidate;
    private final String shapeSetId;

    public CloneCanvasNodeCommand(Node parent, Node candidate, String shapeSetId, ManagedInstance<ChildrenTraverseProcessor> childrenTraverseProcessor) {
        this.parent = parent;
        this.candidate = candidate;
        this.shapeSetId = shapeSetId;
        this.childrenTraverseProcessor = childrenTraverseProcessor;
    }

    public AbstractCanvasCommand createAddCanvasChildNodeCommand(Node parent, Node candidate, String shapeSetId) {
        return new AddCanvasChildNodeCommand(parent, candidate, shapeSetId);
    }

    public CloneCanvasNodeCommand createCloneCanvasNodeCommand(Node parent, Node candidate, String shapeSetId) {
        return new CloneCanvasNodeCommand(parent, candidate, shapeSetId, this.childrenTraverseProcessor);
    }

    public CommandResult<CanvasViolation> execute(AbstractCanvasHandler context) {
        this.commands = new CompositeCommand.Builder().reverse().build();
        this.commands.addCommand((Command)this.createAddCanvasChildNodeCommand(this.getParent(), this.getCandidate(), this.getShapeSetId()));
        if (GraphUtils.hasChildren((Node)this.getCandidate())) {
            Graph graph = context.getGraphIndex().getGraph();
            final ArrayList clonedEdges = new ArrayList();
            ((ChildrenTraverseProcessor)this.childrenTraverseProcessor.get()).setRootUUID(this.getCandidate().getUUID()).traverse((Object)graph, (Object)new AbstractChildrenTraverseCallback<Node<View, Edge>, Edge<Child, Node>>(){

                public boolean startNodeTraversal(List<Node<View, Edge>> parents, Node<View, Edge> node) {
                    CloneCanvasNodeCommand.this.commands.addCommand((Command)CloneCanvasNodeCommand.this.createCloneCanvasNodeCommand(CloneCanvasNodeCommand.this.getCandidate(), node, CloneCanvasNodeCommand.this.getShapeSetId()));
                    clonedEdges.addAll(node.getOutEdges());
                    return false;
                }
            });
            clonedEdges.stream().filter(edge -> edge.getContent() instanceof Dock).forEach(edge -> this.commands.addCommand((Command)new CanvasDockNodeCommand(edge.getSourceNode(), edge.getTargetNode())));
            clonedEdges.stream().filter(edge -> edge.getContent() instanceof ViewConnector).forEach(edge -> this.commands.addCommand((Command)new AddCanvasConnectorCommand((Edge)edge, this.getShapeSetId())));
        }
        if (GraphUtils.hasDockedNodes((Node)this.getCandidate())) {
            List edges = this.getCandidate().getOutEdges();
            edges.stream().filter(edge -> edge.getContent() instanceof Dock).map(edge -> edge.getTargetNode()).forEach(targetNode -> {
                this.commands.addCommand((Command)new AddCanvasChildNodeCommand(this.getParent(), (Node)targetNode, this.getShapeSetId()));
                this.commands.addCommand((Command)new CanvasDockNodeCommand(this.getCandidate(), (Node)targetNode));
            });
        }
        return this.commands.execute((Object)context);
    }

    public CommandResult<CanvasViolation> undo(AbstractCanvasHandler context) {
        return this.commands.undo((Object)context);
    }

    protected CompositeCommand<AbstractCanvasHandler, CanvasViolation> getCommands() {
        return this.commands;
    }

    public ManagedInstance<ChildrenTraverseProcessor> getChildrenTraverseProcessor() {
        return this.childrenTraverseProcessor;
    }

    public Node getParent() {
        return this.parent;
    }

    public Node getCandidate() {
        return this.candidate;
    }

    public String getShapeSetId() {
        return this.shapeSetId;
    }
}

