/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.canvas.command;

import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.command.AbstractCanvasCommand;
import org.kie.workbench.common.stunner.core.client.canvas.command.AddCanvasControlPointCommand;
import org.kie.workbench.common.stunner.core.client.command.CanvasViolation;
import org.kie.workbench.common.stunner.core.client.util.ShapeUtils;
import org.kie.workbench.common.stunner.core.command.CommandResult;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.content.view.ControlPoint;

public class DeleteCanvasControlPointCommand
extends AbstractCanvasCommand {
    private final Edge candidate;
    private final ControlPoint[] controlPoints;

    public DeleteCanvasControlPointCommand(Edge candidate, ControlPoint ... controlPoints) {
        this.candidate = candidate;
        this.controlPoints = controlPoints;
    }

    public CommandResult<CanvasViolation> execute(AbstractCanvasHandler context) {
        ShapeUtils.hideControlPoints(this.candidate, context);
        ShapeUtils.removeControlPoints(this.candidate, context, this.controlPoints);
        ShapeUtils.showControlPoints(this.candidate, context);
        return this.buildResult();
    }

    public CommandResult<CanvasViolation> undo(AbstractCanvasHandler context) {
        return this.newUndoCommand().execute(context);
    }

    protected AddCanvasControlPointCommand newUndoCommand() {
        return new AddCanvasControlPointCommand(this.candidate, this.controlPoints);
    }

    protected ControlPoint[] getControlPoints() {
        return this.controlPoints;
    }
}

