/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.canvas.command;

import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.command.AbstractCanvasCommand;
import org.kie.workbench.common.stunner.core.client.command.CanvasViolation;
import org.kie.workbench.common.stunner.core.client.shape.MutationContext;
import org.kie.workbench.common.stunner.core.client.util.ShapeUtils;
import org.kie.workbench.common.stunner.core.command.CommandResult;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.kie.workbench.common.stunner.core.graph.content.view.ViewConnector;

public class SetCanvasConnectionCommand
extends AbstractCanvasCommand {
    private final Edge<? extends ViewConnector<?>, Node> edge;

    public SetCanvasConnectionCommand(Edge<? extends ViewConnector<?>, Node> edge) {
        this.edge = edge;
    }

    public CommandResult<CanvasViolation> execute(AbstractCanvasHandler context) {
        Node source = this.edge.getSourceNode();
        Node target = this.edge.getTargetNode();
        ShapeUtils.updateEdgeConnections(this.edge, context);
        ShapeUtils.applyConnections(this.edge, context, MutationContext.STATIC);
        if (null != source) {
            context.notifyCanvasElementUpdated((Element)source);
        }
        if (null != target) {
            context.notifyCanvasElementUpdated((Element)target);
        }
        return this.buildResult();
    }

    public CommandResult<CanvasViolation> undo(AbstractCanvasHandler context) {
        return new SetCanvasConnectionCommand(this.edge).execute(context);
    }

    public Edge<? extends View<?>, Node> getEdge() {
        return this.edge;
    }

    public String toString() {
        return this.getClass().getName() + " [candidate=" + this.getUUID((Element<?>)this.edge) + ", sourceNode=" + this.getUUID((Element<?>)this.edge.getSourceNode()) + ", targetNode=" + this.getUUID((Element<?>)this.edge.getTargetNode()) + "]";
    }
}

