/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.canvas.controls.actions;

import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.controls.actions.TextPropertyProvider;
import org.kie.workbench.common.stunner.core.client.command.CanvasCommand;
import org.kie.workbench.common.stunner.core.client.command.CanvasCommandFactory;
import org.kie.workbench.common.stunner.core.client.command.CanvasCommandManager;
import org.kie.workbench.common.stunner.core.command.Command;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.content.definition.Definition;
import org.kie.workbench.common.stunner.core.util.DefinitionUtils;

@ApplicationScoped
public class DefaultTextPropertyProviderImpl
implements TextPropertyProvider {
    private DefinitionUtils definitionUtils;
    private CanvasCommandFactory<AbstractCanvasHandler> canvasCommandFactory;

    public DefaultTextPropertyProviderImpl() {
    }

    @Inject
    public DefaultTextPropertyProviderImpl(DefinitionUtils definitionUtils, CanvasCommandFactory<AbstractCanvasHandler> canvasCommandFactory) {
        this.definitionUtils = definitionUtils;
        this.canvasCommandFactory = canvasCommandFactory;
    }

    @Override
    public int getPriority() {
        return Integer.MAX_VALUE;
    }

    @Override
    public boolean supports(Element<? extends Definition> element) {
        return true;
    }

    @Override
    public String getText(Element<? extends Definition> element) {
        return this.definitionUtils.getName(((Definition)element.getContent()).getDefinition());
    }

    @Override
    public void setText(AbstractCanvasHandler canvasHandler, CanvasCommandManager<AbstractCanvasHandler> commandManager, Element<? extends Definition> element, String text) {
        Object def = ((Definition)element.getContent()).getDefinition();
        String nameId = this.definitionUtils.getNameIdentifier(def);
        if (null != nameId) {
            CanvasCommand command = this.canvasCommandFactory.updatePropertyValue(element, nameId, (Object)text);
            commandManager.execute((Object)canvasHandler, (Command)command);
        }
    }
}

