/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.canvas.controls.builder.impl;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.Default;
import javax.inject.Inject;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.Canvas;
import org.kie.workbench.common.stunner.core.client.canvas.controls.AbstractCanvasHandlerControl;
import org.kie.workbench.common.stunner.core.client.canvas.controls.builder.BuilderControl;
import org.kie.workbench.common.stunner.core.client.canvas.controls.builder.EdgeBuilderControl;
import org.kie.workbench.common.stunner.core.client.canvas.controls.builder.request.EdgeBuildRequest;
import org.kie.workbench.common.stunner.core.client.command.CanvasCommandFactory;
import org.kie.workbench.common.stunner.core.client.command.CanvasCommandManager;
import org.kie.workbench.common.stunner.core.client.command.CanvasViolation;
import org.kie.workbench.common.stunner.core.client.command.RequiresCommandManager;
import org.kie.workbench.common.stunner.core.client.shape.MutationContext;
import org.kie.workbench.common.stunner.core.command.Command;
import org.kie.workbench.common.stunner.core.command.CommandResult;
import org.kie.workbench.common.stunner.core.command.impl.CompositeCommand;
import org.kie.workbench.common.stunner.core.command.util.CommandUtils;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.view.Connection;
import org.kie.workbench.common.stunner.core.graph.content.view.MagnetConnection;

@Dependent
@Default
public class EdgeBuilderControlImpl
extends AbstractCanvasHandlerControl<AbstractCanvasHandler>
implements EdgeBuilderControl<AbstractCanvasHandler> {
    private static Logger LOGGER = Logger.getLogger(EdgeBuilderControlImpl.class.getName());
    private final CanvasCommandFactory<AbstractCanvasHandler> commandFactory;
    private RequiresCommandManager.CommandManagerProvider<AbstractCanvasHandler> commandManagerProvider;

    @Inject
    public EdgeBuilderControlImpl(CanvasCommandFactory<AbstractCanvasHandler> commandFactory) {
        this.commandFactory = commandFactory;
    }

    public void setCommandManagerProvider(RequiresCommandManager.CommandManagerProvider<AbstractCanvasHandler> provider) {
        this.commandManagerProvider = provider;
    }

    public boolean allows(EdgeBuildRequest request) {
        double x = request.getX();
        double y = request.getY();
        Edge edge = request.getEdge();
        AbstractCanvasHandler wch = this.canvasHandler;
        Node inNode = request.getInNode();
        Node outNode = request.getOutNode();
        boolean allowsSourceConn = true;
        if (null != inNode) {
            CommandResult cr1 = this.getCommandManager().allow((Object)wch, (Command)this.commandFactory.setSourceNode(inNode, edge, (Connection)MagnetConnection.Builder.forElement((Element)inNode)));
            allowsSourceConn = this.isAllowed((CommandResult<CanvasViolation>)cr1);
        }
        boolean allowsTargetConn = true;
        if (null != outNode) {
            CommandResult cr2 = this.getCommandManager().allow((Object)wch, (Command)this.commandFactory.setTargetNode(outNode, edge, (Connection)MagnetConnection.Builder.forElement((Element)outNode)));
            allowsTargetConn = this.isAllowed((CommandResult<CanvasViolation>)cr2);
        }
        return allowsSourceConn & allowsTargetConn;
    }

    public void build(EdgeBuildRequest request, BuilderControl.BuildCallback buildCallback) {
        CommandResult results;
        double x = request.getX();
        double y = request.getY();
        Edge edge = request.getEdge();
        AbstractCanvasHandler wch = this.canvasHandler;
        Node inNode = request.getInNode();
        Node outNode = request.getOutNode();
        Canvas canvas = this.canvasHandler.getCanvas();
        if (null == inNode) {
            throw new RuntimeException(" An edge must be into the outgoing edges list from a node.");
        }
        String ssid = this.canvasHandler.getDiagram().getMetadata().getShapeSetId();
        CompositeCommand.Builder commandBuilder = new CompositeCommand.Builder().addCommand((Command)this.commandFactory.addConnector(inNode, edge, (Connection)MagnetConnection.Builder.forElement((Element)inNode), ssid));
        if (null != outNode) {
            commandBuilder.addCommand((Command)this.commandFactory.setTargetNode(outNode, edge, (Connection)MagnetConnection.Builder.forElement((Element)outNode)));
        }
        if (CommandUtils.isError((CommandResult)(results = this.getCommandManager().execute((Object)wch, (Command)commandBuilder.build())))) {
            LOGGER.log(Level.WARNING, results.toString());
        }
        this.canvasHandler.applyElementMutation((Element)edge, MutationContext.STATIC);
        buildCallback.onSuccess(edge.getUUID());
    }

    @Override
    protected void doInit() {
    }

    @Override
    protected void doDestroy() {
        this.commandManagerProvider = null;
    }

    private boolean isAllowed(CommandResult<CanvasViolation> result) {
        return !CommandResult.Type.ERROR.equals((Object)result.getType());
    }

    private CanvasCommandManager<AbstractCanvasHandler> getCommandManager() {
        return this.commandManagerProvider.getCommandManager();
    }
}

