/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.canvas.controls.builder.impl;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Default;
import javax.inject.Inject;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.kie.workbench.common.stunner.core.client.api.ClientDefinitionManager;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.CanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.controls.builder.BuilderControl;
import org.kie.workbench.common.stunner.core.client.canvas.controls.builder.ElementBuilderControl;
import org.kie.workbench.common.stunner.core.client.canvas.controls.builder.impl.AbstractElementBuilderControl;
import org.kie.workbench.common.stunner.core.client.canvas.controls.builder.impl.Observer;
import org.kie.workbench.common.stunner.core.client.canvas.controls.builder.request.ElementBuildRequestImpl;
import org.kie.workbench.common.stunner.core.client.canvas.controls.event.BuildCanvasShapeEvent;
import org.kie.workbench.common.stunner.core.client.canvas.event.selection.CanvasSelectionEvent;
import org.kie.workbench.common.stunner.core.client.command.CanvasCommandFactory;
import org.kie.workbench.common.stunner.core.client.i18n.ClientTranslationMessages;
import org.kie.workbench.common.stunner.core.client.service.ClientFactoryService;
import org.kie.workbench.common.stunner.core.client.service.ClientRuntimeError;
import org.kie.workbench.common.stunner.core.graph.processing.index.bounds.GraphBoundsIndexer;
import org.kie.workbench.common.stunner.core.rule.RuleManager;

@Default
@Observer
@Dependent
public class ObserverBuilderControl
extends AbstractElementBuilderControl
implements ElementBuilderControl<AbstractCanvasHandler> {
    private static Logger LOGGER = Logger.getLogger(ObserverBuilderControl.class.getName());
    private final Event<CanvasSelectionEvent> canvasSelectionEvent;

    @Inject
    public ObserverBuilderControl(ClientDefinitionManager clientDefinitionManager, ClientFactoryService clientFactoryServices, RuleManager ruleManager, CanvasCommandFactory<AbstractCanvasHandler> canvasCommandFactory, ClientTranslationMessages translationMessages, GraphBoundsIndexer graphBoundsIndexer, Event<CanvasSelectionEvent> canvasSelectionEvent) {
        super(clientDefinitionManager, clientFactoryServices, ruleManager, canvasCommandFactory, translationMessages, graphBoundsIndexer);
        this.canvasSelectionEvent = canvasSelectionEvent;
    }

    void onBuildCanvasShape(@Observes BuildCanvasShapeEvent buildCanvasShapeEvent) {
        Object context;
        PortablePreconditions.checkNotNull((String)"buildCanvasShapeEvent", (Object)buildCanvasShapeEvent);
        if (null != this.canvasHandler && null != (context = buildCanvasShapeEvent.getCanvasHandler()) && context.equals(this.canvasHandler)) {
            Object definition = buildCanvasShapeEvent.getDefinition();
            double x = buildCanvasShapeEvent.getX();
            double y = buildCanvasShapeEvent.getY();
            double _x = x >= 0.0 ? x - this.canvasHandler.getAbstractCanvas().getAbsoluteX() : -1.0;
            double _y = y >= 0.0 ? y - this.canvasHandler.getAbstractCanvas().getAbsoluteY() : -1.0;
            ElementBuildRequestImpl request = new ElementBuildRequestImpl(_x, _y, definition);
            this.build(request, new BuilderControl.BuildCallback(){

                public void onSuccess(String uuid) {
                    ObserverBuilderControl.this.canvasSelectionEvent.fire((Object)new CanvasSelectionEvent((CanvasHandler)ObserverBuilderControl.this.canvasHandler, uuid));
                }

                public void onError(ClientRuntimeError error) {
                    LOGGER.log(Level.WARNING, error.toString());
                }
            });
        }
    }
}

