/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.canvas.controls.keyboard;

import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvas;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.CanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.controls.AbstractCanvasHandlerRegistrationControl;
import org.kie.workbench.common.stunner.core.client.canvas.controls.CanvasControl;
import org.kie.workbench.common.stunner.core.client.canvas.controls.keyboard.KeyboardControl;
import org.kie.workbench.common.stunner.core.client.canvas.controls.keyboard.shortcut.KeyboardShortcut;
import org.kie.workbench.common.stunner.core.client.canvas.util.CanvasLayoutUtils;
import org.kie.workbench.common.stunner.core.client.event.keyboard.KeyboardEvent;
import org.kie.workbench.common.stunner.core.client.session.impl.EditorSession;
import org.kie.workbench.common.stunner.core.graph.Element;

public abstract class AbstractCanvasShortcutsControlImpl
extends AbstractCanvasHandlerRegistrationControl<AbstractCanvasHandler>
implements CanvasControl.SessionAware<EditorSession>,
KeyboardControl.KeyShortcutCallback {
    private final Instance<KeyboardShortcut> keyboardShortcutActions;
    protected EditorSession editorSession;

    @Inject
    public AbstractCanvasShortcutsControlImpl(Instance<KeyboardShortcut> keyboardShortcutActions) {
        this.keyboardShortcutActions = keyboardShortcutActions;
    }

    public void register(Element element) {
        this.focusCanvasToActivateKeyboardCanvasControl();
    }

    public void bind(EditorSession session) {
        this.editorSession = session;
        session.getKeyboardControl().addKeyShortcutCallback((KeyboardControl.KeyShortcutCallback)this);
    }

    public void onKeyShortcut(KeyboardEvent.Key ... keys) {
        if (this.selectedNodeId() != null) {
            for (KeyboardShortcut action : this.keyboardShortcutActions) {
                if (!action.matchesPressedKeys(keys) || !action.matchesSelectedElement(this.selectedNodeElement())) continue;
                action.executeAction((CanvasHandler)this.canvasHandler, this.selectedNodeId());
            }
        }
    }

    public String selectedNodeId() {
        if (this.editorSession != null && this.editorSession.getSelectionControl().getSelectedItems().size() == 1) {
            return (String)this.editorSession.getSelectionControl().getSelectedItems().iterator().next();
        }
        return null;
    }

    public Element selectedNodeElement() {
        if (this.selectedNodeId() != null) {
            return CanvasLayoutUtils.getElement(this.canvasHandler, this.selectedNodeId());
        }
        return null;
    }

    private void focusCanvasToActivateKeyboardCanvasControl() {
        if (this.editorSession != null && this.editorSession.getCanvas() != null) {
            ((AbstractCanvas)this.editorSession.getCanvas()).focus();
        }
    }
}

