/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.canvas.controls.select;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.Canvas;
import org.kie.workbench.common.stunner.core.client.canvas.CanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.Layer;
import org.kie.workbench.common.stunner.core.client.canvas.controls.AbstractCanvasHandlerControl;
import org.kie.workbench.common.stunner.core.client.canvas.controls.CanvasRegistrationControl;
import org.kie.workbench.common.stunner.core.client.canvas.controls.select.SelectionControl;
import org.kie.workbench.common.stunner.core.client.canvas.event.registration.CanvasShapeRemovedEvent;
import org.kie.workbench.common.stunner.core.client.canvas.event.selection.CanvasClearSelectionEvent;
import org.kie.workbench.common.stunner.core.client.canvas.event.selection.CanvasSelectionEvent;
import org.kie.workbench.common.stunner.core.client.canvas.util.CanvasLayoutUtils;
import org.kie.workbench.common.stunner.core.client.shape.ShapeState;
import org.kie.workbench.common.stunner.core.client.shape.view.event.MouseClickEvent;
import org.kie.workbench.common.stunner.core.client.shape.view.event.MouseClickHandler;
import org.kie.workbench.common.stunner.core.client.shape.view.event.ViewEventType;
import org.kie.workbench.common.stunner.core.client.shape.view.event.ViewHandler;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.content.definition.Definition;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.kie.workbench.common.stunner.core.util.StringUtils;

public final class MapSelectionControl<H extends AbstractCanvasHandler>
extends AbstractCanvasHandlerControl<H>
implements SelectionControl<H, Element>,
CanvasRegistrationControl<H, Element> {
    private final Consumer<CanvasSelectionEvent> selectionEventConsumer;
    private final Consumer<CanvasClearSelectionEvent> clearSelectionEventConsumer;
    private MouseClickHandler layerClickHandler;
    private final Map<String, Boolean> items = new HashMap<String, Boolean>();
    private boolean readonly;

    public static <H extends AbstractCanvasHandler> MapSelectionControl<H> build(Consumer<CanvasSelectionEvent> selectionEventConsumer, Consumer<CanvasClearSelectionEvent> clearSelectionEventConsumer) {
        return new MapSelectionControl<H>(selectionEventConsumer, clearSelectionEventConsumer);
    }

    MapSelectionControl(Consumer<CanvasSelectionEvent> selectionEventConsumer, Consumer<CanvasClearSelectionEvent> clearSelectionEventConsumer) {
        this.selectionEventConsumer = selectionEventConsumer;
        this.clearSelectionEventConsumer = clearSelectionEventConsumer;
    }

    @Override
    protected void doInit() {
        Layer layer = this.canvasHandler.getCanvas().getLayer();
        MouseClickHandler clickHandler = new MouseClickHandler(){

            public void handle(MouseClickEvent event) {
                if (event.isButtonLeft() || event.isButtonRight()) {
                    MapSelectionControl.this.clearSelection(false);
                    String canvasRootUUID = MapSelectionControl.this.getRootUUID();
                    MapSelectionControl.this.fireCanvasClear();
                    if (null != canvasRootUUID) {
                        MapSelectionControl.this.selectionEventConsumer.accept(new CanvasSelectionEvent((CanvasHandler)MapSelectionControl.this.canvasHandler, canvasRootUUID));
                    }
                }
            }
        };
        layer.addHandler(ViewEventType.MOUSE_CLICK, (ViewHandler)clickHandler);
        this.layerClickHandler = clickHandler;
    }

    public void clear() {
        this.clearSelection(true);
    }

    public void register(Element element) {
        if (!this.itemsRegistered().test(element.getUUID()) && element.getContent() instanceof View) {
            this.items.put(element.getUUID(), false);
        }
    }

    public void deregister(Element element) {
        String uuid = element.getUUID();
        this.deselect(uuid);
        this.items.remove(uuid);
    }

    public SelectionControl<H, Element> select(String uuid) {
        return this.select(Collections.singletonList(uuid));
    }

    public SelectionControl<H, Element> deselect(String uuid) {
        return this.deselect(Collections.singletonList(uuid));
    }

    public boolean isSelected(Element element) {
        return this.isSelected(element.getUUID());
    }

    public Collection<String> getSelectedItems() {
        return this.items.entrySet().stream().filter(Map.Entry::getValue).map(Map.Entry::getKey).collect(Collectors.toList());
    }

    private Collection<String> getUnselectedItems() {
        return this.items.entrySet().stream().filter(entry -> (Boolean)entry.getValue() == false).map(Map.Entry::getKey).collect(Collectors.toList());
    }

    public SelectionControl<H, Element> clearSelection() {
        return this.clearSelection(true);
    }

    public Optional<Object> getSelectedItemDefinition() {
        String cRoot;
        Diagram diagram;
        AbstractCanvasHandler canvasHandler;
        String selectedItemUUID = null;
        Collection<String> selectedItems = this.getSelectedItems();
        if (null != selectedItems && !selectedItems.isEmpty()) {
            selectedItemUUID = selectedItems.iterator().next();
        }
        if (Objects.isNull(selectedItemUUID) && !Objects.isNull(canvasHandler = this.getCanvasHandler()) && !Objects.isNull(diagram = this.getCanvasHandler().getDiagram()) && !StringUtils.isEmpty((String)(cRoot = diagram.getMetadata().getCanvasRootUUID()))) {
            selectedItemUUID = cRoot;
        }
        if (!Objects.isNull(selectedItemUUID)) {
            Element<? extends Definition<?>> element = CanvasLayoutUtils.getElement(this.getCanvasHandler(), selectedItemUUID);
            return Optional.ofNullable(element);
        }
        return Optional.empty();
    }

    public boolean isReadonly() {
        return this.readonly;
    }

    public void setReadonly(boolean readonly) {
        this.readonly = readonly;
    }

    public SelectionControl<H, Element> select(Collection<String> uuids) {
        uuids.stream().filter(this.itemsRegistered()).forEach(uuid -> this.items.put((String)uuid, true));
        this.updateViewShapesState(this.getSelectedItems());
        this.fireSelectedItemsEvent();
        return this;
    }

    public SelectionControl<H, Element> deselect(Collection<String> uuids) {
        uuids.stream().filter(this.itemsRegistered()).forEach(uuid -> this.items.put((String)uuid, false));
        this.updateViewShapesState(this.getUnselectedItems());
        return this;
    }

    public boolean isSelected(String uuid) {
        return this.itemsRegistered().test(uuid) && this.items.get(uuid) != false;
    }

    private SelectionControl<H, Element> clearSelection(boolean fireEvent) {
        this.deselect(this.getSelectedItems());
        if (fireEvent) {
            this.fireCanvasClear();
        }
        return this;
    }

    private void updateViewShapesState(Collection<String> uuids) {
        uuids.stream().map(uuid -> this.getCanvas().getShape(uuid)).filter(Objects::nonNull).forEach(shape -> {
            boolean isSelected = this.isSelected(shape.getUUID());
            if (isSelected && this.isReadonly()) {
                shape.applyState(ShapeState.HIGHLIGHT);
            } else if (isSelected) {
                shape.applyState(ShapeState.SELECTED);
            } else {
                shape.applyState(ShapeState.NONE);
            }
        });
    }

    @Override
    protected void doDestroy() {
        if (null != this.layerClickHandler) {
            this.getCanvas().getLayer().removeHandler((ViewHandler)this.layerClickHandler);
            this.layerClickHandler = null;
        }
        this.items.clear();
    }

    public void onShapeRemoved(CanvasShapeRemovedEvent shapeRemovedEvent) {
        PortablePreconditions.checkNotNull((String)"shapeRemovedEvent", (Object)shapeRemovedEvent);
        if (null == this.canvasHandler) {
            return;
        }
        if (this.getCanvas().equals(shapeRemovedEvent.getCanvas())) {
            this.items.remove(shapeRemovedEvent.getShape().getUUID());
        }
    }

    public void onCanvasElementSelected(CanvasSelectionEvent event) {
        PortablePreconditions.checkNotNull((String)"event", (Object)event);
        if (null == this.canvasHandler) {
            return;
        }
        boolean isSameCtxt = this.canvasHandler.equals(event.getCanvasHandler());
        boolean isSingleSelection = event.getIdentifiers().size() == 1;
        boolean isCanvasRoot = isSingleSelection && ((String)event.getIdentifiers().iterator().next()).equals(this.getRootUUID());
        boolean equals = this.items.entrySet().stream().filter(Map.Entry::getValue).map(Map.Entry::getKey).anyMatch(uuid -> event.getIdentifiers().contains(uuid));
        if (isSameCtxt && !isCanvasRoot && !equals) {
            this.clearSelection(false);
            this.select(event.getIdentifiers());
        }
    }

    public void onCanvasClearSelection(CanvasClearSelectionEvent event) {
        PortablePreconditions.checkNotNull((String)"event", (Object)event);
        if (null != this.canvasHandler && this.canvasHandler.equals(event.getCanvasHandler())) {
            this.clearSelection(false);
        }
    }

    public AbstractCanvasHandler getCanvasHandler() {
        return this.canvasHandler;
    }

    public Predicate<String> itemsRegistered() {
        return this.items::containsKey;
    }

    public Canvas getCanvas() {
        return this.canvasHandler.getCanvas();
    }

    protected String getRootUUID() {
        return this.canvasHandler.getDiagram().getMetadata().getCanvasRootUUID();
    }

    private void fireSelectedItemsEvent() {
        Collection<String> selectedItems = this.getSelectedItems();
        if (!selectedItems.isEmpty()) {
            this.selectionEventConsumer.accept(new CanvasSelectionEvent((CanvasHandler)this.canvasHandler, selectedItems));
        }
    }

    private void fireCanvasClear() {
        this.clearSelectionEventConsumer.accept(new CanvasClearSelectionEvent((CanvasHandler)this.canvasHandler));
    }
}

