/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.canvas.util;

import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.CanvasExport;
import org.kie.workbench.common.stunner.core.client.canvas.CanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.Layer;
import org.uberfire.ext.editor.commons.client.file.exports.FileExport;
import org.uberfire.ext.editor.commons.client.file.exports.ImageDataUriContent;
import org.uberfire.ext.editor.commons.client.file.exports.PdfDocument;
import org.uberfire.ext.editor.commons.client.file.exports.svg.SvgFileExport;
import org.uberfire.ext.editor.commons.file.exports.FileExportsPreferences;
import org.uberfire.ext.editor.commons.file.exports.PdfExportPreferences;

@ApplicationScoped
public class CanvasFileExport {
    private static Logger LOGGER = Logger.getLogger(CanvasFileExport.class.getName());
    private static final String EXT_PNG = "png";
    private static final String EXT_JPG = "jpg";
    private static final String EXT_PDF = "pdf";
    private static final String EXT_SVG = "svg";
    private final CanvasExport<AbstractCanvasHandler> canvasExport;
    private final FileExport<ImageDataUriContent> imageFileExport;
    private final FileExport<PdfDocument> pdfFileExport;
    private final FileExportsPreferences preferences;
    private final SvgFileExport svgFileExport;

    protected CanvasFileExport() {
        this(null, null, null, null, null);
    }

    @Inject
    public CanvasFileExport(CanvasExport<AbstractCanvasHandler> canvasExport, FileExport<ImageDataUriContent> imageFileExport, FileExport<PdfDocument> pdfFileExport, FileExportsPreferences preferences, SvgFileExport svgFileExport) {
        this.canvasExport = canvasExport;
        this.imageFileExport = imageFileExport;
        this.pdfFileExport = pdfFileExport;
        this.preferences = preferences;
        this.svgFileExport = svgFileExport;
    }

    public void exportToSvg(AbstractCanvasHandler canvasHandler, String fileName) {
        String fullFileName = fileName + "." + CanvasFileExport.getFileExtension(Layer.URLDataType.SVG);
        this.svgFileExport.export((Object)this.canvasExport.toContext2D((CanvasHandler)canvasHandler), fullFileName);
    }

    public String exportToSvg(AbstractCanvasHandler canvasHandler) {
        return this.canvasExport.toContext2D((CanvasHandler)canvasHandler).getSerializedSvg();
    }

    public void exportToJpg(AbstractCanvasHandler canvasHandler, String fileName) {
        this.exportImage(canvasHandler, Layer.URLDataType.JPG, fileName);
    }

    public void exportToPng(AbstractCanvasHandler canvasHandler, String fileName) {
        this.exportImage(canvasHandler, Layer.URLDataType.PNG, fileName);
    }

    public void exportToPdf(AbstractCanvasHandler canvasHandler, String fileName) {
        this.loadFileExportPreferences(prefs -> this.exportToPdf(canvasHandler, fileName, prefs.getPdfPreferences()));
    }

    private void exportToPdf(AbstractCanvasHandler canvasHandler, String fileName, PdfExportPreferences pdfPreferences) {
        String dataUrl = this.toDataImageURL(canvasHandler, Layer.URLDataType.JPG);
        String title = canvasHandler.getDiagram().getMetadata().getTitle();
        PdfDocument content = PdfDocument.create((PdfExportPreferences)PdfExportPreferences.create((PdfExportPreferences.Orientation)PdfExportPreferences.Orientation.LANDSCAPE, (PdfExportPreferences.Unit)pdfPreferences.getUnit(), (PdfExportPreferences.Format)pdfPreferences.getFormat()));
        content.addText(title, 5, 15);
        content.addImage(dataUrl, EXT_JPG, 5, 40, 290, 150);
        this.pdfFileExport.export((Object)content, fileName + "." + EXT_PDF);
    }

    private void exportImage(AbstractCanvasHandler canvasHandler, Layer.URLDataType type, String fileName) {
        String dataUrl = this.toDataImageURL(canvasHandler, type);
        ImageDataUriContent content = ImageDataUriContent.create((String)dataUrl);
        this.imageFileExport.export((Object)content, fileName + "." + CanvasFileExport.getFileExtension(type));
    }

    private String toDataImageURL(AbstractCanvasHandler canvasHandler, Layer.URLDataType urlDataType) {
        return this.canvasExport.toImageData((CanvasHandler)canvasHandler, urlDataType);
    }

    private static String getFileExtension(Layer.URLDataType type) {
        switch (type) {
            case JPG: {
                return EXT_JPG;
            }
            case PNG: {
                return EXT_PNG;
            }
            case SVG: {
                return EXT_SVG;
            }
        }
        throw new UnsupportedOperationException("No mimeType supported for " + type);
    }

    private void loadFileExportPreferences(Consumer<FileExportsPreferences> preferencesConsumer) {
        this.preferences.load(preferencesConsumer::accept, error -> LOGGER.log(Level.SEVERE, "Cannot load preferences.", (Throwable)error));
    }
}

