/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.canvas.util;

import com.google.gwt.logging.client.LogConfiguration;
import com.google.gwt.user.client.Timer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CanvasLoadingObserver {
    private static Logger LOGGER = Logger.getLogger(CanvasLoadingObserver.class.getName());
    private static final int TIMEOUT_DURATION = 5000;
    private Callback callback;
    private Timer timeout;
    private int duration = 5000;

    public void setLoadingObserverCallback(Callback callback) {
        this.callback = callback;
    }

    public void setTimeoutDuration(int duration) {
        this.duration = duration;
    }

    public void loadingStarted() {
        if (null != this.callback && null != this.timeout && !this.timeout.isRunning()) {
            this.callback.onLoadingStarted();
            CanvasLoadingObserver.log("Starting timeout...");
            this.timeout = new Timer(){

                public void run() {
                    CanvasLoadingObserver.logWarn("Loading timeout timer fired after " + CanvasLoadingObserver.this.duration + "sec... something went wrong?");
                    CanvasLoadingObserver.this.loadingCompleted();
                }
            };
            this.timeout.schedule(this.duration);
        }
    }

    public void loadingCompleted() {
        this.clearTimeout();
        if (null != this.callback) {
            this.callback.onLoadingCompleted();
        }
    }

    private void clearTimeout() {
        if (null != this.timeout) {
            CanvasLoadingObserver.log("Clearing timeout...");
            if (this.timeout.isRunning()) {
                this.timeout.cancel();
            }
            this.timeout = null;
        }
    }

    private static void log(String message) {
        CanvasLoadingObserver.log(Level.FINE, message);
    }

    private static void logWarn(String message) {
        CanvasLoadingObserver.log(Level.WARNING, message);
    }

    private static void log(Level level, String message) {
        if (LogConfiguration.loggingIsEnabled()) {
            LOGGER.log(level, message);
        }
    }

    public static interface Callback {
        public void onLoadingStarted();

        public void onLoadingCompleted();
    }
}

