/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.components.palette;

import java.util.LinkedList;
import java.util.List;
import org.kie.workbench.common.stunner.core.client.components.palette.CollapsedDefaultPaletteItem;
import org.kie.workbench.common.stunner.core.client.components.palette.DefaultPaletteCategory;
import org.kie.workbench.common.stunner.core.client.components.palette.DefaultPaletteGroup;
import org.kie.workbench.common.stunner.core.client.components.palette.DefaultPaletteItem;
import org.kie.workbench.common.stunner.core.definition.shape.Glyph;

public class DefaultPaletteDefinitionBuilders {
    public static final int DEFAULT_ICON_SIZE = 16;

    public static class CategoryBuilder
    extends AbstractItemBuilder<DefaultPaletteCategory, CategoryBuilder> {
        private static final int ICON_SIZE = 21;
        private Glyph glyph;

        public CategoryBuilder() {
            this.iconSize = 21;
        }

        public CategoryBuilder setGlyph(Glyph glyph) {
            this.glyph = glyph;
            return this;
        }

        @Override
        public DefaultPaletteCategory build() {
            return new DefaultPaletteCategory(this.itemId, this.definitionId, this.title, this.description, this.tooltip, this.iconSize, new LinkedList<DefaultPaletteItem>(), this.glyph);
        }
    }

    public static class GroupBuilder
    extends AbstractItemBuilder<DefaultPaletteGroup, GroupBuilder> {
        @Override
        public DefaultPaletteGroup build() {
            return new DefaultPaletteGroup(this.itemId, this.definitionId, this.title, this.description, this.tooltip, this.iconSize, (List<DefaultPaletteItem>)new LinkedList<DefaultPaletteItem>());
        }
    }

    public static class CollapsedItemBuilder
    extends AbstractItemBuilder<CollapsedDefaultPaletteItem, CollapsedItemBuilder> {
        public static final int ICON_SIZE = 21;

        @Override
        public CollapsedDefaultPaletteItem build() {
            return new CollapsedDefaultPaletteItem(this.itemId, this.definitionId, this.tooltip, 21);
        }
    }

    public static class ItemBuilder
    extends AbstractItemBuilder<DefaultPaletteItem, ItemBuilder> {
        @Override
        public DefaultPaletteItem build() {
            return new DefaultPaletteItem(this.itemId, this.definitionId, this.title, this.description, this.tooltip, this.iconSize);
        }
    }

    public static abstract class AbstractItemBuilder<I extends DefaultPaletteItem, T extends AbstractItemBuilder> {
        protected String itemId = null;
        protected String title = "";
        protected String description = "";
        protected String tooltip = "";
        protected String definitionId = null;
        protected int iconSize = 16;

        public abstract I build();

        public T setItemId(String itemId) {
            this.itemId = itemId;
            return this.cast();
        }

        public T setTitle(String title) {
            this.title = title;
            return this.cast();
        }

        public T setDescription(String description) {
            this.description = description;
            return this.cast();
        }

        public T setTooltip(String tooltip) {
            this.tooltip = tooltip;
            return this.cast();
        }

        public T setDefinitionId(String definitionId) {
            this.definitionId = definitionId;
            return this.cast();
        }

        public T setIconSize(int iconSize) {
            this.iconSize = iconSize;
            return this.cast();
        }

        private T cast() {
            return (T)this;
        }
    }
}

