/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.components.palette;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.kie.workbench.common.stunner.core.client.components.palette.AbstractPaletteDefinitionBuilder;
import org.kie.workbench.common.stunner.core.client.resources.StunnerCommonImageResources;
import org.kie.workbench.common.stunner.core.client.shape.ImageDataUriGlyph;
import org.kie.workbench.common.stunner.core.definition.adapter.binding.BindableAdapterUtils;
import org.kie.workbench.common.stunner.core.definition.shape.Glyph;
import org.kie.workbench.common.stunner.core.i18n.StunnerTranslationService;

public class DefaultPaletteDefinitionProviders {
    public static final Function<String, Glyph> DEFAULT_CATEGORY_GLYPH_PROVIDER = category -> ImageDataUriGlyph.create(StunnerCommonImageResources.INSTANCE.gears().getSafeUri());

    public static Predicate<String> isType(Class<?> type) {
        return id -> DefaultPaletteDefinitionProviders.getId(type).equals(id);
    }

    public static String getId(Class<?> type) {
        return BindableAdapterUtils.getGenericClassName(type);
    }

    private static String getDefinitionId(Class<?> type) {
        return null != type ? BindableAdapterUtils.getGenericClassName(type) : null;
    }

    public static class CategoryDefinition {
        private final String id;
        private Optional<Class<?>> defaultDefinitionType;
        private Optional<Glyph> glyph;

        private CategoryDefinition(String id) {
            this.id = id;
            this.defaultDefinitionType = Optional.empty();
            this.glyph = Optional.empty();
        }

        public CategoryDefinition bindToDefinition(Class<?> type) {
            this.defaultDefinitionType = Optional.of(type);
            return this;
        }

        public CategoryDefinition useGlyph(Glyph glyph) {
            this.glyph = Optional.of(glyph);
            return this;
        }
    }

    public static class CategoryDefinitionProvider {
        private final Class<?> categoryTYpe;
        private final Map<String, CategoryDefinition> definitions;

        public CategoryDefinitionProvider(Class<?> categoryTYpe) {
            this.categoryTYpe = categoryTYpe;
            this.definitions = new LinkedHashMap<String, CategoryDefinition>();
        }

        public CategoryDefinitionProvider put(String categoryId, Consumer<CategoryDefinition> definitionConsumer) {
            if (this.definitions.containsKey(categoryId)) {
                throw new IllegalArgumentException("Setting the definition for an already existing palette category. [category=" + categoryId + "]");
            }
            CategoryDefinition definition = new CategoryDefinition(categoryId);
            this.definitions.put(categoryId, definition);
            definitionConsumer.accept(definition);
            return this;
        }

        public Function<String, String> definitionIdProvider() {
            return catId -> {
                CategoryDefinition definition = this.definitions.get(catId);
                return null != definition ? DefaultPaletteDefinitionProviders.getDefinitionId(definition.defaultDefinitionType.orElse(null)) : null;
            };
        }

        public Function<String, Glyph> glyphProvider() {
            return catId -> {
                CategoryDefinition definition = this.definitions.get(catId);
                return null != definition ? (Glyph)definition.glyph.orElse(null) : null;
            };
        }

        public AbstractPaletteDefinitionBuilder.ItemMessageProvider categoryMessageProvider(StunnerTranslationService translationService) {
            return new DefaultCategoryMessageProvider(this.categoryTYpe, translationService);
        }
    }

    public static class DefaultCustomGroupMessageProvider
    implements AbstractPaletteDefinitionBuilder.ItemMessageProvider {
        private final StunnerTranslationService translationService;

        public DefaultCustomGroupMessageProvider(StunnerTranslationService translationService) {
            this.translationService = translationService;
        }

        @Override
        public String getTitle(String id) {
            return this.translationService.getValue(id);
        }

        @Override
        public String getDescription(String id) {
            return this.translationService.getValue(id);
        }
    }

    public static class DefaultMorphGroupMessageProvider
    implements AbstractPaletteDefinitionBuilder.ItemMessageProvider {
        private final StunnerTranslationService translationService;

        public DefaultMorphGroupMessageProvider(StunnerTranslationService translationService) {
            this.translationService = translationService;
        }

        @Override
        public String getTitle(String id) {
            return this.translationService.getValue(id);
        }

        @Override
        public String getDescription(String id) {
            return this.translationService.getValue(id);
        }
    }

    public static class DefaultItemMessageProvider
    implements AbstractPaletteDefinitionBuilder.ItemMessageProvider {
        private final StunnerTranslationService translationService;

        public DefaultItemMessageProvider(StunnerTranslationService translationService) {
            this.translationService = translationService;
        }

        @Override
        public String getTitle(String id) {
            return this.translationService.getDefinitionTitle(id);
        }

        @Override
        public String getDescription(String id) {
            return this.translationService.getDefinitionDescription(id);
        }
    }

    public static class DefaultCategoryMessageProvider
    implements AbstractPaletteDefinitionBuilder.ItemMessageProvider {
        private final Class<?> categoryTYpe;
        private final StunnerTranslationService translationService;

        public DefaultCategoryMessageProvider(Class<?> categoryTYpe, StunnerTranslationService translationService) {
            this.categoryTYpe = categoryTYpe;
            this.translationService = translationService;
        }

        @Override
        public String getTitle(String id) {
            return this.getText(id);
        }

        @Override
        public String getDescription(String id) {
            return this.getText(id);
        }

        private String getText(String id) {
            String value = this.translationService.getValue(this.categoryTYpe.getName() + "." + id);
            return null != value && value.trim().length() > 0 ? value : id;
        }
    }

    public static class DefaultMessageProvider
    implements AbstractPaletteDefinitionBuilder.ItemMessageProvider {
        @Override
        public String getTitle(String id) {
            return id;
        }

        @Override
        public String getDescription(String id) {
            return id;
        }
    }
}

