/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.components.toolbox.actions;

import javax.enterprise.event.Event;
import org.kie.workbench.common.stunner.core.client.api.ClientFactoryManager;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.CanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.controls.actions.CreateNodeAction;
import org.kie.workbench.common.stunner.core.client.canvas.event.selection.CanvasSelectionEvent;
import org.kie.workbench.common.stunner.core.client.canvas.util.CanvasLayoutUtils;
import org.kie.workbench.common.stunner.core.client.command.CanvasCommand;
import org.kie.workbench.common.stunner.core.client.command.CanvasCommandFactory;
import org.kie.workbench.common.stunner.core.client.command.SessionCommandManager;
import org.kie.workbench.common.stunner.core.client.session.Session;
import org.kie.workbench.common.stunner.core.command.Command;
import org.kie.workbench.common.stunner.core.command.CommandResult;
import org.kie.workbench.common.stunner.core.command.impl.DeferredCompositeCommand;
import org.kie.workbench.common.stunner.core.command.util.CommandUtils;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.definition.Definition;
import org.kie.workbench.common.stunner.core.graph.content.view.Connection;
import org.kie.workbench.common.stunner.core.graph.content.view.MagnetConnection;
import org.kie.workbench.common.stunner.core.graph.content.view.Point2D;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.kie.workbench.common.stunner.core.graph.content.view.ViewConnector;
import org.kie.workbench.common.stunner.core.graph.util.GraphUtils;
import org.kie.workbench.common.stunner.core.util.UUID;

public abstract class GeneralCreateNodeAction
implements CreateNodeAction<AbstractCanvasHandler> {
    private final ClientFactoryManager clientFactoryManager;
    private final CanvasLayoutUtils canvasLayoutUtils;
    private final Event<CanvasSelectionEvent> selectionEvent;
    private final SessionCommandManager<AbstractCanvasHandler> sessionCommandManager;
    private final CanvasCommandFactory<AbstractCanvasHandler> canvasCommandFactory;

    public GeneralCreateNodeAction(ClientFactoryManager clientFactoryManager, CanvasLayoutUtils canvasLayoutUtils, Event<CanvasSelectionEvent> selectionEvent, @Session SessionCommandManager<AbstractCanvasHandler> sessionCommandManager, CanvasCommandFactory<AbstractCanvasHandler> canvasCommandFactory) {
        this.clientFactoryManager = clientFactoryManager;
        this.canvasLayoutUtils = canvasLayoutUtils;
        this.selectionEvent = selectionEvent;
        this.sessionCommandManager = sessionCommandManager;
        this.canvasCommandFactory = canvasCommandFactory;
    }

    public void executeAction(AbstractCanvasHandler canvasHandler, String sourceNodeId, String targetNodeId, String connectorId) {
        Element<? extends Definition<?>> element = CanvasLayoutUtils.getElement(canvasHandler, sourceNodeId);
        Node sourceNode = element.asNode();
        Edge connector = this.clientFactoryManager.newElement(UUID.uuid(), connectorId).asEdge();
        Node targetNode = this.clientFactoryManager.newElement(UUID.uuid(), targetNodeId).asNode();
        DeferredCompositeCommand.Builder builder = new DeferredCompositeCommand.Builder().deferCommand(() -> this.addNode(canvasHandler, sourceNode, targetNode)).deferCommand(() -> this.updateNodeLocation(canvasHandler, sourceNode, targetNode)).deferCommand(() -> this.addEdge(canvasHandler, sourceNode, targetNode, connector)).deferCommand(() -> this.setEdgeTarget(connector, targetNode, sourceNode));
        CommandResult result = this.sessionCommandManager.execute((Object)canvasHandler, (Command)builder.build());
        if (!CommandUtils.isError((CommandResult)result)) {
            CanvasLayoutUtils.fireElementSelectedEvent(this.selectionEvent, canvasHandler, targetNode.getUUID());
        }
    }

    private CanvasCommand<AbstractCanvasHandler> updateNodeLocation(CanvasHandler canvasHandler, Node<View<?>, Edge> sourceNode, Node<View<?>, Edge> targetNode) {
        Point2D location = this.canvasLayoutUtils.getNext(canvasHandler, sourceNode, targetNode);
        return this.canvasCommandFactory.updatePosition(targetNode, location);
    }

    private CanvasCommand<AbstractCanvasHandler> addEdge(CanvasHandler canvasHandler, Node<View<?>, Edge> sourceNode, Node<View<?>, Edge> targetNode, Edge<? extends ViewConnector<?>, Node> connector) {
        return this.canvasCommandFactory.addConnector(sourceNode, connector, (Connection)MagnetConnection.Builder.forElement(sourceNode, targetNode), canvasHandler.getDiagram().getMetadata().getShapeSetId());
    }

    private CanvasCommand<AbstractCanvasHandler> setEdgeTarget(Edge<? extends ViewConnector<?>, Node> connector, Node<View<?>, Edge> targetNode, Node<View<?>, Edge> sourceNode) {
        return this.canvasCommandFactory.setTargetNode(targetNode, connector, (Connection)MagnetConnection.Builder.forElement(targetNode, sourceNode));
    }

    private CanvasCommand<AbstractCanvasHandler> addNode(CanvasHandler canvasHandler, Node<View<?>, Edge> sourceNode, Node<View<?>, Edge> targetNode) {
        Node parent = (Node)GraphUtils.getParent(sourceNode);
        String shapeSetId = canvasHandler.getDiagram().getMetadata().getShapeSetId();
        if (null != parent) {
            return this.canvasCommandFactory.addChildNode(parent, targetNode, shapeSetId);
        }
        return this.canvasCommandFactory.addNode(targetNode, shapeSetId);
    }
}

