/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.session.command;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import javax.annotation.PreDestroy;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.Any;
import javax.inject.Inject;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.kie.workbench.common.stunner.core.client.session.ClientSession;
import org.kie.workbench.common.stunner.core.client.session.command.AbstractClientSessionCommand;
import org.kie.workbench.common.stunner.core.client.session.command.ClientSessionCommand;
import org.kie.workbench.common.stunner.core.client.session.impl.InstanceUtils;
import org.kie.workbench.common.stunner.core.util.DefinitionUtils;

@Dependent
public class ManagedClientSessionCommands {
    private static final int EXPECTED_COMMANDS_SIZE = 20;
    private final DefinitionUtils definitionUtils;
    private final ManagedInstance<ClientSessionCommand> sessionCommands;
    private final List<Class<? extends ClientSessionCommand>> types;
    private final List<ClientSessionCommand> commands;

    @Inject
    public ManagedClientSessionCommands(DefinitionUtils definitionUtils, @Any ManagedInstance<ClientSessionCommand> sessionCommands) {
        this(definitionUtils, sessionCommands, 20);
    }

    public ManagedClientSessionCommands(DefinitionUtils definitionUtils, @Any ManagedInstance<ClientSessionCommand> sessionCommands, int size) {
        this.definitionUtils = definitionUtils;
        this.sessionCommands = sessionCommands;
        this.types = new ArrayList<Class<? extends ClientSessionCommand>>(size);
        this.commands = new ArrayList<ClientSessionCommand>(size);
    }

    public ManagedClientSessionCommands register(Class<? extends ClientSessionCommand> type) {
        this.types.add(type);
        return this;
    }

    public void bind(ClientSession session) {
        String id = session.getCanvasHandler().getDiagram().getMetadata().getDefinitionSetId();
        Annotation qualifier = this.definitionUtils.getQualifier(id);
        List instances = this.types.stream().map(type -> (ClientSessionCommand)InstanceUtils.lookup(this.sessionCommands, type, qualifier)).collect(Collectors.toList());
        this.clearCommands();
        this.commands.addAll(instances);
        this.commands.forEach(c -> this.safeBind((ClientSessionCommand)c, session));
    }

    public <S extends ClientSessionCommand> S get(int index) {
        return (S)this.commands.get(index);
    }

    public <S extends ClientSessionCommand> void visit(BiConsumer<Class<S>, S> visitor) {
        for (int i = 0; i < this.commands.size(); ++i) {
            ClientSessionCommand command = this.commands.get(i);
            Class<? extends ClientSessionCommand> type = this.types.get(i);
            visitor.accept(type, command);
        }
    }

    @PreDestroy
    public void destroy() {
        this.clearCommands();
        this.types.clear();
        this.sessionCommands.destroyAll();
    }

    private void clearCommands() {
        this.commands.forEach(ClientSessionCommand::destroy);
        this.commands.clear();
    }

    private void safeBind(ClientSessionCommand command, ClientSession session) {
        if (command instanceof AbstractClientSessionCommand) {
            AbstractClientSessionCommand abstractCommand = (AbstractClientSessionCommand)command;
            if (abstractCommand.accepts(session)) {
                abstractCommand.bind(session);
            } else {
                abstractCommand.enable(false);
            }
        } else {
            command.bind(session);
        }
    }
}

