/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.session.command.impl;

import java.util.logging.Logger;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.enterprise.inject.Default;
import javax.inject.Inject;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.controls.clipboard.ClipboardControl;
import org.kie.workbench.common.stunner.core.client.canvas.controls.keyboard.KeysMatcher;
import org.kie.workbench.common.stunner.core.client.canvas.controls.select.SelectionControl;
import org.kie.workbench.common.stunner.core.client.canvas.event.registration.CanvasElementsClearEvent;
import org.kie.workbench.common.stunner.core.client.canvas.event.selection.CanvasClearSelectionEvent;
import org.kie.workbench.common.stunner.core.client.canvas.event.selection.CanvasSelectionEvent;
import org.kie.workbench.common.stunner.core.client.event.keyboard.KeyboardEvent;
import org.kie.workbench.common.stunner.core.client.session.ClientSession;
import org.kie.workbench.common.stunner.core.client.session.command.ClientSessionCommand;
import org.kie.workbench.common.stunner.core.client.session.command.impl.AbstractSelectionAwareSessionCommand;
import org.kie.workbench.common.stunner.core.client.session.command.impl.CopySelectionSessionCommandExecutedEvent;
import org.kie.workbench.common.stunner.core.client.session.impl.EditorSession;
import org.kie.workbench.common.stunner.core.graph.Element;

@Dependent
@Default
public class CopySelectionSessionCommand
extends AbstractSelectionAwareSessionCommand<EditorSession> {
    private static Logger LOGGER = Logger.getLogger(CopySelectionSessionCommand.class.getName());
    private final Event<CopySelectionSessionCommandExecutedEvent> commandExecutedEvent;
    private ClipboardControl clipboardControl;

    public CopySelectionSessionCommand() {
        this(null);
    }

    @Inject
    public CopySelectionSessionCommand(Event<CopySelectionSessionCommandExecutedEvent> commandExecutedEvent) {
        super(true);
        this.commandExecutedEvent = commandExecutedEvent;
    }

    @Override
    public void bind(EditorSession session) {
        super.bind(session);
        session.getKeyboardControl().addKeyShortcutCallback(this::onKeyDownEvent);
        this.clipboardControl = session.getClipboardControl();
    }

    @Override
    public boolean accepts(ClientSession session) {
        return session instanceof EditorSession;
    }

    protected void onKeyDownEvent(KeyboardEvent.Key ... keys) {
        if (this.isEnabled()) {
            this.handleCtrlC(keys);
        }
    }

    private void handleCtrlC(KeyboardEvent.Key[] keys) {
        if (KeysMatcher.doKeysMatch(keys, KeyboardEvent.Key.CONTROL, KeyboardEvent.Key.C)) {
            this.execute();
        }
    }

    @Override
    public <V> void execute(ClientSessionCommand.Callback<V> callback) {
        if (null != ((EditorSession)this.getSession()).getSelectionControl()) {
            try {
                SelectionControl<AbstractCanvasHandler, Element> selectionControl = ((EditorSession)this.getSession()).getSelectionControl();
                this.clipboardControl.set((Element[])selectionControl.getSelectedItems().stream().map(this::getElement).toArray(Element[]::new));
                this.commandExecutedEvent.fire((Object)new CopySelectionSessionCommandExecutedEvent(this, (EditorSession)this.getSession()));
                callback.onSuccess();
            }
            catch (Exception e) {
                LOGGER.severe("Error on copy selection." + e.getMessage());
                return;
            }
        }
    }

    @Override
    protected void doDestroy() {
        super.doDestroy();
        this.clipboardControl = null;
    }

    @Override
    protected void handleCanvasSelectionEvent(CanvasSelectionEvent event) {
        if (event.getIdentifiers().isEmpty() || this.onlyCanvasRootSelected(event)) {
            this.enable(false);
        } else {
            this.enable(true);
        }
    }

    @Override
    protected void handleCanvasClearSelectionEvent(CanvasClearSelectionEvent event) {
        this.enable(false);
    }

    @Override
    protected void handleCanvasElementsClearEvent(CanvasElementsClearEvent event) {
        this.enable(false);
    }
}

